/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import java.util.Objects;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TurbineDiagnostic {
    private final Diagnostic.Kind severity;
    private final TurbineError.ErrorKind kind;
    private final ImmutableList<Object> args;
    private final @Nullable SourceFile source;
    private final int position;

    private TurbineDiagnostic(Diagnostic.Kind severity, TurbineError.ErrorKind kind, ImmutableList<Object> args, @Nullable SourceFile source, int position) {
        this.severity = Objects.requireNonNull(severity);
        this.kind = Objects.requireNonNull(kind);
        this.args = Objects.requireNonNull(args);
        this.source = source;
        this.position = position;
    }

    public TurbineError.ErrorKind kind() {
        return this.kind;
    }

    public Diagnostic.Kind severity() {
        return this.severity;
    }

    public String diagnostic() {
        StringBuilder sb = new StringBuilder(this.path());
        if (this.line() != -1) {
            sb.append(':').append(this.line());
        }
        sb.append(": error: ");
        sb.append(this.message()).append(System.lineSeparator());
        if (this.line() != -1 && this.column() != -1) {
            sb.append(CharMatcher.breakingWhitespace().trimTrailingFrom((CharSequence)this.source.lineMap().line(this.position))).append(System.lineSeparator());
            sb.append(Strings.repeat((String)" ", (int)(this.column() - 1))).append('^');
        }
        return sb.toString();
    }

    public ImmutableList<Object> args() {
        return this.args;
    }

    private static TurbineDiagnostic create(Diagnostic.Kind severity, TurbineError.ErrorKind kind, ImmutableList<Object> args, SourceFile source, int position) {
        switch (kind) {
            case SYMBOL_NOT_FOUND: {
                Preconditions.checkArgument((args.size() == 1 && Iterables.getOnlyElement(args) instanceof ClassSymbol ? 1 : 0) != 0, (String)"diagnostic (%s) has invalid argument %s", (Object)((Object)kind), args);
                break;
            }
        }
        return new TurbineDiagnostic(severity, kind, args, source, position);
    }

    public static TurbineDiagnostic format(Diagnostic.Kind severity, TurbineError.ErrorKind kind, String message) {
        return TurbineDiagnostic.create(severity, kind, (ImmutableList<Object>)ImmutableList.of((Object)message), null, -1);
    }

    public static TurbineDiagnostic format(SourceFile source, TurbineError.ErrorKind kind, Object ... args) {
        return TurbineDiagnostic.create(Diagnostic.Kind.ERROR, kind, (ImmutableList<Object>)ImmutableList.copyOf((Object[])args), source, -1);
    }

    public static TurbineDiagnostic format(Diagnostic.Kind severity, SourceFile source, int position, TurbineError.ErrorKind kind, Object ... args) {
        return TurbineDiagnostic.create(severity, kind, (ImmutableList<Object>)ImmutableList.copyOf((Object[])args), source, position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.source, this.position});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TurbineDiagnostic)) {
            return false;
        }
        TurbineDiagnostic that = (TurbineDiagnostic)obj;
        return this.severity.equals((Object)that.severity) && this.kind.equals((Object)that.kind) && this.args.equals(that.args) && Objects.equals(this.source, that.source) && this.position == that.position;
    }

    public String path() {
        return this.source != null && this.source.path() != null ? this.source.path() : "<>";
    }

    public int line() {
        return this.position != -1 ? this.source.lineMap().lineNumber(this.position) : -1;
    }

    public int column() {
        return this.position != -1 ? this.source.lineMap().column(this.position) + 1 : -1;
    }

    public String message() {
        return this.kind.format(this.args.toArray());
    }
}

