/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import lombok.ast.BooleanLiteral;
import lombok.ast.CharLiteral;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.IntegralLiteral;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.StringLiteral;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceActions;

public class LiteralsActions
extends SourceActions {
    public LiteralsActions(Source source) {
        super(source);
    }

    public Node createNullLiteral(String raw) {
        return this.posify(new NullLiteral().rawValue(raw));
    }

    public Node createStringLiteral(String raw) {
        return this.posify(new StringLiteral().rawValue(raw));
    }

    public Node createCharLiteral(String raw) {
        return this.posify(new CharLiteral().rawValue(raw));
    }

    public Node createBooleanLiteral(String raw) {
        return this.posify(new BooleanLiteral().rawValue(raw));
    }

    public Node createNumberLiteral(String raw) {
        if (raw == null) {
            return this.posify(new IntegralLiteral());
        }
        String v = raw.trim().toLowerCase();
        if (v.startsWith("0x")) {
            if (v.contains("p")) {
                return this.posify(new FloatingPointLiteral().rawValue(raw));
            }
            return this.posify(new IntegralLiteral().rawValue(raw));
        }
        if (v.contains(".") || v.endsWith("d") || v.endsWith("f") || v.contains("e")) {
            return this.posify(new FloatingPointLiteral().rawValue(raw));
        }
        return this.posify(new IntegralLiteral().rawValue(raw));
    }
}

