/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.DescribedNode;
import lombok.ast.Expression;
import lombok.ast.Literal;
import lombok.ast.LiteralType;

public class FloatingPointLiteral
extends AbstractNode.WithParens
implements Literal,
Expression,
DescribedNode {
    private Double value;
    private String rawValue;
    private String errorReasonForValue = "Missing value";
    private boolean markedAsFloat;
    private LiteralType literalType = LiteralType.DECIMAL;

    @Override
    public boolean isStatementExpression() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.value != null ? String.valueOf(this.value) : null;
    }

    public String getErrorReasonForValue() {
        return this.errorReasonForValue;
    }

    public LiteralType astLiteralType() {
        return this.literalType;
    }

    public FloatingPointLiteral astLiteralType(LiteralType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (type == LiteralType.OCTAL) {
            throw new IllegalArgumentException("there's no such thing as an octal floating point literal");
        }
        this.literalType = type;
        this.updateRawValue();
        return this;
    }

    public boolean astMarkedAsFloat() {
        return this.markedAsFloat;
    }

    public FloatingPointLiteral astMarkedAsFloat(boolean marked) {
        this.markedAsFloat = marked;
        this.updateRawValue();
        return this;
    }

    @Override
    public FloatingPointLiteral copy() {
        FloatingPointLiteral result = new FloatingPointLiteral();
        result.value = this.value;
        result.rawValue = result.rawValue;
        result.errorReasonForValue = result.errorReasonForValue;
        result.markedAsFloat = result.markedAsFloat;
        result.literalType = this.literalType;
        return result;
    }

    public FloatingPointLiteral astDoubleValue(double value) {
        this.checkSpecialValues(value);
        this.markedAsFloat = false;
        this.value = value;
        this.errorReasonForValue = null;
        this.updateRawValue();
        return this;
    }

    public FloatingPointLiteral astFloatValue(float value) {
        this.checkSpecialValues(value);
        this.markedAsFloat = true;
        this.errorReasonForValue = null;
        this.value = value;
        this.updateRawValue();
        return this;
    }

    private void checkSpecialValues(double value) throws AstException {
        if (Double.isNaN(value)) {
            throw new AstException(this, "NaN cannot be expressed as a floating point literal");
        }
        if (Double.isInfinite(value)) {
            throw new AstException(this, "Infinity cannot be expressed as a floating point literal");
        }
        if ((Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L) {
            throw new AstException(this, "Floating Point literals cannot be negative; wrap a literal in a UnaryExpression to accomplish this");
        }
    }

    private void updateRawValue() {
        if (this.errorReasonForValue != null) {
            return;
        }
        String suffix = this.markedAsFloat ? "F" : "";
        switch (this.literalType) {
            case DECIMAL: {
                this.rawValue = this.value + suffix;
                break;
            }
            case HEXADECIMAL: {
                this.rawValue = Double.toHexString(this.value) + suffix;
                break;
            }
            default: {
                assert (false) : "literalType is null / octal";
                break;
            }
        }
    }

    public FloatingPointLiteral rawValue(String raw) {
        if (raw == null) {
            this.rawValue = null;
            this.value = null;
            this.errorReasonForValue = "Missing value";
            this.markedAsFloat = false;
        } else {
            this.rawValue = raw;
            this.errorReasonForValue = null;
            String v = raw.trim();
            this.markedAsFloat = v.endsWith("F") || v.endsWith("f");
            String string = v = this.markedAsFloat || v.endsWith("D") || v.endsWith("d") ? raw.substring(0, raw.length() - 1) : raw;
            if (v.startsWith("-")) {
                this.errorReasonForValue = "Floating Point literals can't start with -; wrap them in a UnaryExpression: " + v;
                this.value = null;
                return this;
            }
            try {
                this.value = Double.parseDouble(v);
                this.literalType = v.startsWith("0x") || v.startsWith("0X") ? LiteralType.HEXADECIMAL : LiteralType.DECIMAL;
            }
            catch (NumberFormatException e) {
                this.value = null;
                this.errorReasonForValue = "Not a valid floating point literal: " + v;
            }
        }
        return this;
    }

    public double astDoubleValue() throws AstException {
        return this.value == null ? 0.0 : this.value;
    }

    public float astFloatValue() throws AstException {
        return this.value == null ? 0.0f : this.value.floatValue();
    }

    @Override
    public String rawValue() {
        return this.rawValue;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (!visitor.visitFloatingPointLiteral(this)) {
            visitor.endVisit(this);
        }
        visitor.afterVisitFloatingPointLiteral(this);
    }
}

