/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import com.google.common.testing.SerializableTester;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class ListSubListTester<E>
extends AbstractListTester<E> {
    public void testSubList_startNegative() {
        try {
            this.getList().subList(-1, 0);
            ListSubListTester.fail((String)"subList(-1, 0) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSubList_endTooLarge() {
        try {
            this.getList().subList(0, this.getNumElements() + 1);
            ListSubListTester.fail((String)"subList(0, size + 1) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSubList_startGreaterThanEnd() {
        try {
            this.getList().subList(1, 0);
            ListSubListTester.fail((String)"subList(1, 0) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSubList_empty() {
        ListSubListTester.assertEquals((String)"subList(0, 0) should be empty", Collections.emptyList(), this.getList().subList(0, 0));
    }

    public void testSubList_entireList() {
        ListSubListTester.assertEquals((String)"subList(0, size) should be equal to the original list", this.getList(), this.getList().subList(0, this.getNumElements()));
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSubList_subListRemoveAffectsOriginal() {
        List subList = this.getList().subList(0, 1);
        subList.remove(0);
        List expected = Arrays.asList(this.createSamplesArray()).subList(1, this.getNumElements());
        this.expectContents(expected);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSubList_subListClearAffectsOriginal() {
        List subList = this.getList().subList(0, 1);
        subList.clear();
        List expected = Arrays.asList(this.createSamplesArray()).subList(1, this.getNumElements());
        this.expectContents(expected);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testSubList_subListAddAffectsOriginal() {
        List subList = this.getList().subList(0, 0);
        subList.add(this.e3());
        this.expectAdded(0, this.e3());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSubList_subListSetAffectsOriginal() {
        List subList = this.getList().subList(0, 1);
        subList.set(0, this.e3());
        List expected = Helpers.copyToList(this.createSamplesArray());
        expected.set(0, this.e3());
        this.expectContents(expected);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSubList_originalListSetAffectsSubList() {
        List subList = this.getList().subList(0, 1);
        this.getList().set(0, this.e3());
        ListSubListTester.assertEquals((String)"A set() call to a list after a sublist has been created should be reflected in the sublist", Collections.singletonList(this.e3()), subList);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_REMOVE_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_subListRemoveAffectsOriginalLargeList() {
        List subList = this.getList().subList(1, 3);
        subList.remove(this.e2());
        List expected = Helpers.copyToList(this.createSamplesArray());
        expected.remove(2);
        this.expectContents(expected);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_subListAddAtIndexAffectsOriginalLargeList() {
        List subList = this.getList().subList(2, 3);
        subList.add(0, this.e3());
        this.expectAdded(2, this.e3());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_subListSetAffectsOriginalLargeList() {
        List subList = this.getList().subList(1, 2);
        subList.set(0, this.e3());
        List expected = Helpers.copyToList(this.createSamplesArray());
        expected.set(1, this.e3());
        this.expectContents(expected);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_originalListSetAffectsSubListLargeList() {
        List subList = this.getList().subList(1, 3);
        this.getList().set(1, this.e3());
        ListSubListTester.assertEquals((String)"A set() call to a list after a sublist has been created should be reflected in the sublist", Arrays.asList(this.e3(), this.e2()), subList);
    }

    public void testSubList_ofSubListEmpty() {
        List subList = this.getList().subList(0, 0).subList(0, 0);
        ListSubListTester.assertEquals((String)"subList(0, 0).subList(0, 0) should be an empty list", Collections.emptyList(), subList);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_ofSubListNonEmpty() {
        List subList = this.getList().subList(0, 2).subList(1, 2);
        ListSubListTester.assertEquals((String)"subList(0, 2).subList(1, 2) should be a single-element list of the element at index 1", Collections.singletonList(this.getOrderedElements().get(1)), subList);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSubList_size() {
        List list = this.getList();
        int size = this.getNumElements();
        ListSubListTester.assertEquals((int)size, (int)list.subList(0, size).size());
        ListSubListTester.assertEquals((int)(size - 1), (int)list.subList(0, size - 1).size());
        ListSubListTester.assertEquals((int)(size - 1), (int)list.subList(1, size).size());
        ListSubListTester.assertEquals((int)0, (int)list.subList(size, size).size());
        ListSubListTester.assertEquals((int)0, (int)list.subList(0, 0).size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSubList_isEmpty() {
        List list = this.getList();
        int size = this.getNumElements();
        for (List subList : Arrays.asList(list.subList(0, size), list.subList(0, size - 1), list.subList(1, size), list.subList(0, 0), list.subList(size, size))) {
            ListSubListTester.assertEquals((subList.size() == 0 ? 1 : 0) != 0, (boolean)subList.isEmpty());
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_get() {
        List list = this.getList();
        int size = this.getNumElements();
        List copy = list.subList(0, size);
        List head = list.subList(0, size - 1);
        List tail = list.subList(1, size);
        ListSubListTester.assertEquals(list.get(0), copy.get(0));
        ListSubListTester.assertEquals(list.get(size - 1), copy.get(size - 1));
        ListSubListTester.assertEquals(list.get(1), tail.get(0));
        ListSubListTester.assertEquals(list.get(size - 1), tail.get(size - 2));
        ListSubListTester.assertEquals(list.get(0), head.get(0));
        ListSubListTester.assertEquals(list.get(size - 2), head.get(size - 2));
        for (List subList : Arrays.asList(copy, head, tail)) {
            for (int index : Arrays.asList(-1, subList.size())) {
                try {
                    subList.get(index);
                    ListSubListTester.fail((String)"expected IndexOutOfBoundsException");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_contains() {
        List list = this.getList();
        int size = this.getNumElements();
        List copy = list.subList(0, size);
        List head = list.subList(0, size - 1);
        List tail = list.subList(1, size);
        ListSubListTester.assertTrue((boolean)copy.contains(list.get(0)));
        ListSubListTester.assertTrue((boolean)head.contains(list.get(0)));
        ListSubListTester.assertTrue((boolean)tail.contains(list.get(1)));
        ListSubListTester.assertTrue((boolean)copy.contains(list.get(size - 1)));
        ListSubListTester.assertTrue((boolean)head.contains(list.get(size - 2)));
        ListSubListTester.assertTrue((boolean)tail.contains(list.get(size - 1)));
        ListSubListTester.assertFalse((boolean)head.contains(list.get(size - 1)));
        ListSubListTester.assertFalse((boolean)tail.contains(list.get(0)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_indexOf() {
        List list = this.getList();
        int size = this.getNumElements();
        List copy = list.subList(0, size);
        List head = list.subList(0, size - 1);
        List tail = list.subList(1, size);
        ListSubListTester.assertEquals((int)0, (int)copy.indexOf(list.get(0)));
        ListSubListTester.assertEquals((int)0, (int)head.indexOf(list.get(0)));
        ListSubListTester.assertEquals((int)0, (int)tail.indexOf(list.get(1)));
        ListSubListTester.assertEquals((int)(size - 1), (int)copy.indexOf(list.get(size - 1)));
        ListSubListTester.assertEquals((int)(size - 2), (int)head.indexOf(list.get(size - 2)));
        ListSubListTester.assertEquals((int)(size - 2), (int)tail.indexOf(list.get(size - 1)));
        ListSubListTester.assertEquals((int)-1, (int)head.indexOf(list.get(size - 1)));
        ListSubListTester.assertEquals((int)-1, (int)tail.indexOf(list.get(0)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testSubList_lastIndexOf() {
        List list = this.getList();
        int size = list.size();
        List copy = list.subList(0, size);
        List head = list.subList(0, size - 1);
        List tail = list.subList(1, size);
        ListSubListTester.assertEquals((int)(size - 1), (int)copy.lastIndexOf(list.get(size - 1)));
        ListSubListTester.assertEquals((int)(size - 2), (int)head.lastIndexOf(list.get(size - 2)));
        ListSubListTester.assertEquals((int)(size - 2), (int)tail.lastIndexOf(list.get(size - 1)));
        ListSubListTester.assertEquals((int)0, (int)copy.lastIndexOf(list.get(0)));
        ListSubListTester.assertEquals((int)0, (int)head.lastIndexOf(list.get(0)));
        ListSubListTester.assertEquals((int)0, (int)tail.lastIndexOf(list.get(1)));
        ListSubListTester.assertEquals((int)-1, (int)head.lastIndexOf(list.get(size - 1)));
        ListSubListTester.assertEquals((int)-1, (int)tail.lastIndexOf(list.get(0)));
    }

    @CollectionFeature.Require(value={CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS})
    public void testReserializeWholeSubList() {
        SerializableTester.reserializeAndAssert(this.getList().subList(0, this.getNumElements()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS})
    public void testReserializeEmptySubList() {
        SerializableTester.reserializeAndAssert(this.getList().subList(0, 0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testReserializeSubList() {
        SerializableTester.reserializeAndAssert(this.getList().subList(0, 2));
    }

    @GwtIncompatible
    public static Method getSubListOriginalListSetAffectsSubListMethod() {
        return Helpers.getMethod(ListSubListTester.class, "testSubList_originalListSetAffectsSubList");
    }

    @GwtIncompatible
    public static Method getSubListOriginalListSetAffectsSubListLargeListMethod() {
        return Helpers.getMethod(ListSubListTester.class, "testSubList_originalListSetAffectsSubListLargeList");
    }

    @GwtIncompatible
    public static Method getSubListSubListRemoveAffectsOriginalLargeListMethod() {
        return Helpers.getMethod(ListSubListTester.class, "testSubList_subListRemoveAffectsOriginalLargeList");
    }
}

