/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import javax.lang.model.element.Modifier;

@BugPattern(name="EqualsGetClass", summary="Prefer instanceof to getClass when implementing Object#equals.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public final class EqualsGetClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_CLASS = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").named("getClass");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!GET_CLASS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        TreePath methodTreePath = state.findPathToEnclosing(new Class[]{MethodTree.class});
        if (methodTreePath == null) {
            return Description.NO_MATCH;
        }
        ClassTree classTree = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
        if (classTree == null || classTree.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (classSymbol == null || classSymbol.isAnonymous()) {
            return Description.NO_MATCH;
        }
        MethodTree methodTree = (MethodTree)methodTreePath.getLeaf();
        if (!Matchers.equalsMethodDeclaration().matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        VariableTree parameter = (VariableTree)Iterables.getOnlyElement(methodTree.getParameters());
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)parameter);
        if (symbol == null || receiver == null || receiver.getKind() != Tree.Kind.IDENTIFIER || !symbol.equals(ASTHelpers.getSymbol((Tree)receiver))) {
            return Description.NO_MATCH;
        }
        EqualsFixer fixer = new EqualsFixer(symbol, ASTHelpers.getSymbol((ClassTree)classTree), state);
        fixer.scan(methodTreePath, null);
        return this.describeMatch(methodTree, (Fix)fixer.getFix());
    }

    private static class EqualsFixer
    extends TreePathScanner<Void, Void> {
        private static final Matcher<ExpressionTree> GET_CLASS = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").named("getClass").withParameters(new String[0]);
        private static final Matcher<ExpressionTree> THIS_CLASS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{GET_CLASS, (Matcher & Serializable)(tree, unused) -> EqualsFixer.matchesThis(tree)}), (Matcher & Serializable)(tree, unused) -> EqualsFixer.matchesClass(tree)});
        private static final Matcher<ExpressionTree> EQUALS = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").named("equals").withParameters(new String[]{"java.lang.Object"});
        private final Symbol parameter;
        private final Symbol.ClassSymbol classSymbol;
        private final VisitorState state;
        private final SuggestedFix.Builder fix = SuggestedFix.builder();
        private final Matcher<ExpressionTree> isParameter;
        private final Matcher<ExpressionTree> otherClass;
        private boolean matchedGetClass = false;
        private boolean failed = false;

        private static boolean matchesThis(ExpressionTree tree) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            if (receiver == null) {
                return true;
            }
            while (!(receiver instanceof IdentifierTree)) {
                if (receiver instanceof ParenthesizedTree) {
                    receiver = ((ParenthesizedTree)receiver).getExpression();
                    continue;
                }
                if (receiver instanceof TypeCastTree) {
                    receiver = ((TypeCastTree)receiver).getExpression();
                    continue;
                }
                return false;
            }
            Symbol symbol = ASTHelpers.getSymbol((Tree)receiver);
            return symbol != null && symbol.getSimpleName().contentEquals("this");
        }

        private static boolean matchesClass(ExpressionTree tree) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
            if (!(symbol instanceof Symbol.VarSymbol)) {
                return false;
            }
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
            return ((Name)varSymbol.getSimpleName()).contentEquals("class");
        }

        private static boolean matchesNull(ExpressionTree tree) {
            return tree.getKind() == Tree.Kind.NULL_LITERAL;
        }

        private EqualsFixer(Symbol parameter, Symbol.ClassSymbol classSymbol, VisitorState visitorState) {
            this.parameter = parameter;
            this.classSymbol = classSymbol;
            this.state = visitorState;
            this.isParameter = (Matcher & Serializable)(tree, state) -> parameter.equals(ASTHelpers.getSymbol((Tree)tree));
            this.otherClass = Matchers.allOf((Matcher[])new Matcher[]{GET_CLASS, (Matcher & Serializable)(tree, state) -> parameter.equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)))});
        }

        @Override
        public Void visitBinary(BinaryTree binaryTree, Void unused) {
            if (binaryTree.getKind() != Tree.Kind.NOT_EQUAL_TO && binaryTree.getKind() != Tree.Kind.EQUAL_TO) {
                return (Void)super.visitBinary(binaryTree, null);
            }
            if (this.matchesEitherWay(binaryTree, this.isParameter, (Matcher<ExpressionTree>)(Matcher & Serializable)(tree, s) -> EqualsFixer.matchesNull(tree))) {
                if (binaryTree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                    this.makeAlwaysTrue();
                }
                if (binaryTree.getKind() == Tree.Kind.EQUAL_TO) {
                    this.makeAlwaysFalse();
                }
                return null;
            }
            if (this.matchesEitherWay(binaryTree, THIS_CLASS, this.otherClass)) {
                this.matchedGetClass = true;
                String instanceOf = String.format("%s instanceof %s", this.parameter.getSimpleName(), this.classSymbol.getSimpleName());
                if (binaryTree.getKind() == Tree.Kind.EQUAL_TO) {
                    this.fix.replace((Tree)binaryTree, instanceOf);
                }
                if (binaryTree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                    this.fix.replace((Tree)binaryTree, String.format("!(%s)", instanceOf));
                }
            }
            return (Void)super.visitBinary(binaryTree, null);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
            if (!EQUALS.matches((Tree)node, this.state)) {
                return null;
            }
            ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(node.getArguments());
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)node);
            if (receiver == null) {
                return null;
            }
            if (this.matchesEitherWay(argument, receiver, THIS_CLASS, this.otherClass)) {
                this.matchedGetClass = true;
                String replacement = String.format("%s instanceof %s", this.parameter.getSimpleName(), this.classSymbol.getSimpleName());
                if (this.getCurrentPath().getParentPath().getLeaf() instanceof UnaryTree) {
                    replacement = String.format("(%s)", replacement);
                }
                this.fix.replace((Tree)node, replacement);
            }
            return (Void)super.visitMethodInvocation(node, null);
        }

        private boolean matchesEitherWay(BinaryTree binaryTree, Matcher<ExpressionTree> matcherA, Matcher<ExpressionTree> matcherB) {
            return this.matchesEitherWay(binaryTree.getLeftOperand(), binaryTree.getRightOperand(), matcherA, matcherB);
        }

        private boolean matchesEitherWay(ExpressionTree treeA, ExpressionTree treeB, Matcher<ExpressionTree> matcherA, Matcher<ExpressionTree> matcherB) {
            return matcherA.matches((Tree)treeA, this.state) && matcherB.matches((Tree)treeB, this.state) || matcherA.matches((Tree)treeB, this.state) && matcherB.matches((Tree)treeA, this.state);
        }

        private void makeAlwaysTrue() {
            this.removeFromBinary(Tree.Kind.CONDITIONAL_AND);
        }

        private void makeAlwaysFalse() {
            TreePath enclosingPath = this.getCurrentPath().getParentPath();
            while (enclosingPath.getLeaf() instanceof ParenthesizedTree) {
                enclosingPath = enclosingPath.getParentPath();
            }
            Tree enclosing = enclosingPath.getLeaf();
            if (enclosing instanceof IfTree) {
                IfTree ifTree = (IfTree)enclosing;
                if (ifTree.getElseStatement() == null) {
                    this.fix.replace((Tree)ifTree, "");
                } else {
                    int stripExtra = ifTree.getElseStatement() instanceof BlockTree ? 1 : 0;
                    this.fix.replace(((JCTree)((Object)ifTree)).getStartPosition(), ((JCTree)((Object)ifTree.getElseStatement())).getStartPosition() + stripExtra, "").replace(this.state.getEndPosition((Tree)ifTree.getElseStatement()) - stripExtra, this.state.getEndPosition((Tree)ifTree.getElseStatement()), "");
                }
                return;
            }
            this.removeFromBinary(Tree.Kind.CONDITIONAL_OR);
        }

        private void removeFromBinary(Tree.Kind ifKind) {
            TreePath outsideParensPath = this.getCurrentPath().getParentPath();
            TreePath justInsideBinaryPath = this.getCurrentPath();
            while (outsideParensPath.getLeaf() instanceof ParenthesizedTree) {
                justInsideBinaryPath = outsideParensPath;
                outsideParensPath = outsideParensPath.getParentPath();
            }
            Tree superTree = outsideParensPath.getLeaf();
            if (superTree.getKind() != ifKind) {
                this.failed = true;
                return;
            }
            BinaryTree superBinary = (BinaryTree)superTree;
            if (superBinary.getLeftOperand().equals(justInsideBinaryPath.getLeaf())) {
                this.removeLeftOperand(superBinary);
            } else {
                this.removeRightOperand(superBinary);
            }
        }

        private void removeLeftOperand(BinaryTree superBinary) {
            this.fix.replace(((JCTree)((Object)superBinary.getLeftOperand())).getStartPosition(), ((JCTree)((Object)superBinary.getRightOperand())).getStartPosition(), "");
        }

        private void removeRightOperand(BinaryTree superBinary) {
            this.fix.replace(this.state.getEndPosition((Tree)superBinary.getLeftOperand()), this.state.getEndPosition((Tree)superBinary.getRightOperand()), "");
        }

        private SuggestedFix getFix() {
            return this.matchedGetClass && !this.failed ? this.fix.build() : SuggestedFix.builder().build();
        }
    }
}

