/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.AutoValue_Commented;
import com.google.errorprone.util.OffsetComment;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;

@AutoValue
public abstract class Commented<T extends Tree> {
    public abstract T tree();

    public abstract ImmutableList<Tokens.Comment> beforeComments();

    public abstract ImmutableList<Tokens.Comment> afterComments();

    static <T extends Tree> Builder<T> builder() {
        return new AutoValue_Commented.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder<T extends Tree> {
        Builder() {
        }

        abstract Builder<T> setTree(T var1);

        protected abstract ImmutableList.Builder<Tokens.Comment> beforeCommentsBuilder();

        protected abstract ImmutableList.Builder<Tokens.Comment> afterCommentsBuilder();

        Builder<T> addComment(Tokens.Comment comment, int nodePosition, int tokenizingOffset, Position position) {
            OffsetComment offsetComment = new OffsetComment(comment, tokenizingOffset);
            if (comment.getSourcePos(0) < nodePosition) {
                if (position.equals((Object)Position.BEFORE) || position.equals((Object)Position.ANY)) {
                    this.beforeCommentsBuilder().add((Object)offsetComment);
                }
            } else if (position.equals((Object)Position.AFTER) || position.equals((Object)Position.ANY)) {
                this.afterCommentsBuilder().add((Object)offsetComment);
            }
            return this;
        }

        Builder<T> addAllComment(Iterable<? extends Tokens.Comment> comments, int nodePosition, int tokenizingOffset, Position position) {
            for (Tokens.Comment comment : comments) {
                this.addComment(comment, nodePosition, tokenizingOffset, position);
            }
            return this;
        }

        abstract Commented<T> build();
    }

    public static enum Position {
        BEFORE,
        AFTER,
        ANY;

    }
}

