/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.common.Duration;
import com.google.instrumentation.stats.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IntervalAggregation {
    private final List<Tag> tags;
    private final List<Interval> intervals;

    public static final IntervalAggregation create(List<Tag> tags, List<Interval> intervals) {
        return new IntervalAggregation(tags, intervals);
    }

    public final List<Tag> getTags() {
        return this.tags;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    private IntervalAggregation(List<Tag> tags, List<Interval> intervals) {
        this.tags = tags;
        this.intervals = Collections.unmodifiableList(new ArrayList<Interval>(intervals));
    }

    public static final class Interval {
        private final Duration intervalSize;
        private final double count;
        private final double sum;

        public static Interval create(Duration intervalSize, double count, double sum) {
            return new Interval(intervalSize, count, sum);
        }

        public Duration getIntervalSize() {
            return this.intervalSize;
        }

        public double getCount() {
            return this.count;
        }

        public double getSum() {
            return this.sum;
        }

        private Interval(Duration intervalSize, double count, double sum) {
            this.intervalSize = intervalSize;
            this.count = count;
            this.sum = sum;
        }
    }
}

