/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.pubapi;

import com.sun.tools.sjavac.pubapi.PubApiTypeParam;
import com.sun.tools.sjavac.pubapi.TypeDesc;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class PubMethod
implements Serializable {
    private static final long serialVersionUID = -7813050194553446243L;
    Set<Modifier> modifiers;
    List<PubApiTypeParam> typeParams;
    TypeDesc returnType;
    String identifier;
    List<TypeDesc> paramTypes;
    List<TypeDesc> throwDecls;

    public PubMethod(Set<Modifier> set, List<PubApiTypeParam> list, TypeDesc typeDesc, String string, List<TypeDesc> list2, List<TypeDesc> list3) {
        this.modifiers = set;
        this.typeParams = list;
        this.returnType = typeDesc;
        this.identifier = string;
        this.paramTypes = list2;
        this.throwDecls = list3;
    }

    public String asSignatureString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.typeParams.size() > 0) {
            stringBuilder.append(this.typeParams.stream().map(PubApiTypeParam::asString).collect(Collectors.joining(",", "<", "> ")));
        }
        stringBuilder.append(TypeDesc.encodeAsString(this.returnType));
        stringBuilder.append(" ");
        stringBuilder.append(this.identifier);
        stringBuilder.append("(");
        stringBuilder.append(this.paramTypes.stream().map(TypeDesc::encodeAsString).collect(Collectors.joining(",")));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PubMethod pubMethod = (PubMethod)object;
        return this.modifiers.equals(pubMethod.modifiers) && this.typeParams.equals(pubMethod.typeParams) && this.returnType.equals(pubMethod.returnType) && this.identifier.equals(pubMethod.identifier) && this.paramTypes.equals(pubMethod.paramTypes) && this.throwDecls.equals(pubMethod.throwDecls);
    }

    public int hashCode() {
        return this.modifiers.hashCode() ^ this.typeParams.hashCode() ^ this.returnType.hashCode() ^ this.identifier.hashCode() ^ this.paramTypes.hashCode() ^ this.throwDecls.hashCode();
    }

    public String toString() {
        return String.format("%s[modifiers: %s, typeParams: %s, retType: %s, identifier: %s, params: %s, throws: %s]", this.getClass().getSimpleName(), this.modifiers, this.typeParams, this.returnType, this.identifier, this.paramTypes, this.throwDecls);
    }
}

