/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.ElementScanner9;
import javax.lang.model.util.Elements;

public class JavacRoundEnvironment
implements RoundEnvironment {
    private final boolean processingOver;
    private final boolean errorRaised;
    private final ProcessingEnvironment processingEnv;
    private final Elements eltUtils;
    private final Set<? extends Element> rootElements;
    private static final String NOT_AN_ANNOTATION_TYPE = "The argument does not represent an annotation type: ";

    JavacRoundEnvironment(boolean bl, boolean bl2, Set<? extends Element> set, ProcessingEnvironment processingEnvironment) {
        this.processingOver = bl;
        this.errorRaised = bl2;
        this.rootElements = set;
        this.processingEnv = processingEnvironment;
        this.eltUtils = processingEnvironment.getElementUtils();
    }

    public String toString() {
        return String.format("[errorRaised=%b, rootElements=%s, processingOver=%b]", this.errorRaised, this.rootElements, this.processingOver);
    }

    @Override
    public boolean processingOver() {
        return this.processingOver;
    }

    @Override
    public boolean errorRaised() {
        return this.errorRaised;
    }

    @Override
    public Set<? extends Element> getRootElements() {
        return this.rootElements;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement typeElement) {
        this.throwIfNotAnnotation(typeElement);
        Set set = Collections.emptySet();
        AnnotationSetScanner annotationSetScanner = new AnnotationSetScanner(set);
        for (Element element : this.rootElements) {
            set = (Set)((ElementScanner6)annotationSetScanner).scan(element, typeElement);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<? extends Element> getElementsAnnotatedWithAny(TypeElement ... typeElementArray) {
        void var3_5;
        LinkedHashSet<TypeElement> linkedHashSet = new LinkedHashSet<TypeElement>(typeElementArray.length);
        for (TypeElement typeElement : typeElementArray) {
            this.throwIfNotAnnotation(typeElement);
            linkedHashSet.add(typeElement);
        }
        Set<Element> set = Collections.emptySet();
        AnnotationSetMultiScanner annotationSetMultiScanner = new AnnotationSetMultiScanner(set);
        for (Element element : this.rootElements) {
            Set set2 = (Set)((ElementScanner6)annotationSetMultiScanner).scan(element, linkedHashSet);
        }
        return var3_5;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> clazz) {
        this.throwIfNotAnnotation(clazz);
        String string = clazz.getCanonicalName();
        if (string == null) {
            return Collections.emptySet();
        }
        TypeElement typeElement = this.eltUtils.getTypeElement(string);
        if (typeElement == null) {
            return Collections.emptySet();
        }
        return this.getElementsAnnotatedWith(typeElement);
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWithAny(Set<Class<? extends Annotation>> set) {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>(set.size());
        for (Class<? extends Annotation> clazz : set) {
            this.throwIfNotAnnotation(clazz);
            String string = clazz.getCanonicalName();
            if (string == null) continue;
            arrayList.add(this.eltUtils.getTypeElement(string));
        }
        return this.getElementsAnnotatedWithAny(arrayList.toArray(new TypeElement[0]));
    }

    private Element mirrorAsElement(AnnotationMirror annotationMirror) {
        return annotationMirror.getAnnotationType().asElement();
    }

    private void throwIfNotAnnotation(Class<? extends Annotation> clazz) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + clazz);
        }
    }

    private void throwIfNotAnnotation(TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + typeElement);
        }
    }

    private static abstract class ElementScanningIncludingTypeParameters<R, P>
    extends ElementScanner9<R, P> {
        protected ElementScanningIncludingTypeParameters(R r) {
            super(r);
        }

        @Override
        public R visitType(TypeElement typeElement, P p) {
            this.scan(typeElement.getTypeParameters(), p);
            return super.visitType(typeElement, p);
        }

        @Override
        public R visitExecutable(ExecutableElement executableElement, P p) {
            this.scan(executableElement.getTypeParameters(), p);
            return super.visitExecutable(executableElement, p);
        }
    }

    private class AnnotationSetMultiScanner
    extends ElementScanningIncludingTypeParameters<Set<Element>, Set<TypeElement>> {
        private Set<Element> annotatedElements;

        AnnotationSetMultiScanner(Set<Element> set) {
            super(set);
            this.annotatedElements = new LinkedHashSet<Element>();
        }

        @Override
        public Set<Element> scan(Element element, Set<TypeElement> set) {
            for (AnnotationMirror annotationMirror : JavacRoundEnvironment.this.eltUtils.getAllAnnotationMirrors(element)) {
                if (!set.contains(JavacRoundEnvironment.this.mirrorAsElement(annotationMirror))) continue;
                this.annotatedElements.add(element);
                break;
            }
            element.accept(this, set);
            return this.annotatedElements;
        }
    }

    private class AnnotationSetScanner
    extends ElementScanningIncludingTypeParameters<Set<Element>, TypeElement> {
        private Set<Element> annotatedElements;

        AnnotationSetScanner(Set<Element> set) {
            super(set);
            this.annotatedElements = new LinkedHashSet<Element>();
        }

        @Override
        public Set<Element> scan(Element element, TypeElement typeElement) {
            for (AnnotationMirror annotationMirror : JavacRoundEnvironment.this.eltUtils.getAllAnnotationMirrors(element)) {
                if (!typeElement.equals(JavacRoundEnvironment.this.mirrorAsElement(annotationMirror))) continue;
                this.annotatedElements.add(element);
                break;
            }
            element.accept(this, typeElement);
            return this.annotatedElements;
        }
    }
}

