/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.evaluation.Stack;
import proguard.evaluation.value.Value;

public class TracedStack
extends Stack {
    private Value producerValue;
    private Stack producerStack;
    private Stack actualProducerStack;

    public TracedStack(int n) {
        super(n);
        this.producerStack = new Stack(n);
        this.actualProducerStack = new Stack(n);
    }

    public TracedStack(TracedStack tracedStack) {
        super(tracedStack);
        this.producerStack = new Stack(tracedStack.producerStack);
        this.actualProducerStack = new Stack(tracedStack.actualProducerStack);
    }

    public void setProducerValue(Value value) {
        this.producerValue = value;
    }

    public Value getBottomProducerValue(int n) {
        return this.producerStack.getBottom(n);
    }

    public Value getBottomActualProducerValue(int n) {
        return this.actualProducerStack.getBottom(n);
    }

    public Value getTopProducerValue(int n) {
        return this.producerStack.getTop(n);
    }

    public Value getTopActualProducerValue(int n) {
        return this.actualProducerStack.getTop(n);
    }

    @Override
    public void reset(int n) {
        super.reset(n);
        this.producerStack.reset(n);
        this.actualProducerStack.reset(n);
    }

    public void copy(TracedStack tracedStack) {
        super.copy(tracedStack);
        this.producerStack.copy(tracedStack.producerStack);
        this.actualProducerStack.copy(tracedStack.actualProducerStack);
    }

    public boolean generalize(TracedStack tracedStack) {
        return super.generalize(tracedStack) | this.producerStack.generalize(tracedStack.producerStack) | this.actualProducerStack.generalize(tracedStack.actualProducerStack);
    }

    @Override
    public void clear() {
        super.clear();
        this.producerStack.clear();
        this.actualProducerStack.clear();
    }

    @Override
    public void removeTop(int n) {
        super.removeTop(n);
        this.producerStack.removeTop(n);
        this.actualProducerStack.removeTop(n);
    }

    @Override
    public void push(Value value) {
        super.push(value);
        this.producerPush();
        if (value.isCategory2()) {
            this.producerPush();
        }
    }

    @Override
    public Value pop() {
        Value value = super.pop();
        this.producerPop();
        if (value.isCategory2()) {
            this.producerPop();
        }
        return value;
    }

    @Override
    public void pop1() {
        super.pop1();
        this.producerPop();
    }

    @Override
    public void pop2() {
        super.pop2();
        this.producerPop();
        this.producerPop();
    }

    @Override
    public void dup() {
        super.dup();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup();
    }

    @Override
    public void dup_x1() {
        super.dup_x1();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup_x1();
    }

    @Override
    public void dup_x2() {
        super.dup_x2();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup_x2();
    }

    @Override
    public void dup2() {
        super.dup2();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup2();
    }

    @Override
    public void dup2_x1() {
        super.dup2_x1();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup2_x1();
    }

    @Override
    public void dup2_x2() {
        super.dup2_x2();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup2_x2();
    }

    @Override
    public void swap() {
        super.swap();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.swap();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TracedStack tracedStack = (TracedStack)object;
        return super.equals(object) && this.producerStack.equals(tracedStack.producerStack) && this.actualProducerStack.equals(tracedStack.actualProducerStack);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.producerStack.hashCode() ^ this.actualProducerStack.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.values[i];
            Value value2 = this.producerStack.getBottom(i);
            Value value3 = this.actualProducerStack.getBottom(i);
            stringBuffer = stringBuffer.append('[').append(value2 == null ? "empty:" : (value2.equals(value3) ? value2.toString() : value2.toString() + value3.toString())).append(value == null ? "empty" : value.toString()).append(']');
        }
        return stringBuffer.toString();
    }

    private void producerPush() {
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.push(this.producerValue);
    }

    private void producerPop() {
        this.producerStack.pop();
        this.actualProducerStack.pop();
    }
}

