/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation.inference;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.dataflow.nullnesspropagation.inference.InferenceVariable;
import com.google.errorprone.dataflow.nullnesspropagation.inference.InferredNullability;
import com.google.errorprone.dataflow.nullnesspropagation.inference.ProperInferenceVar;
import com.google.errorprone.dataflow.nullnesspropagation.inference.TypeArgInferenceVar;
import com.google.errorprone.dataflow.nullnesspropagation.inference.TypeVariableInferenceVar;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.List;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public class NullnessQualifierInference
extends TreeScanner<Void, Void> {
    private static final LoadingCache<Tree, InferredNullability> inferenceCache = CacheBuilder.newBuilder().maximumSize(1L).build((CacheLoader)new CacheLoader<Tree, InferredNullability>(){

        public InferredNullability load(Tree methodOrInitializer) {
            NullnessQualifierInference inferenceEngine = new NullnessQualifierInference(methodOrInitializer);
            inferenceEngine.scan(methodOrInitializer, null);
            return new InferredNullability((Graph<InferenceVariable>)inferenceEngine.qualifierConstraints);
        }
    });
    private final MutableGraph<InferenceVariable> qualifierConstraints;
    private final Tree currentMethodOrInitializerOrLambda;

    public static InferredNullability getInferredNullability(Tree methodOrInitializerOrLambda) {
        Preconditions.checkArgument((methodOrInitializerOrLambda instanceof MethodTree || methodOrInitializerOrLambda instanceof LambdaExpressionTree || methodOrInitializerOrLambda instanceof BlockTree || methodOrInitializerOrLambda instanceof VariableTree ? 1 : 0) != 0, (String)"Tree `%s` is not a lambda, initializer, or method.", (Object)methodOrInitializerOrLambda);
        try {
            return (InferredNullability)inferenceCache.getUnchecked((Object)methodOrInitializerOrLambda);
        }
        catch (UncheckedExecutionException e) {
            throw e.getCause() instanceof Symbol.CompletionFailure ? (Symbol.CompletionFailure)e.getCause() : e;
        }
    }

    private NullnessQualifierInference(Tree currentMethodOrInitializerOrLambda) {
        this.currentMethodOrInitializerOrLambda = currentMethodOrInitializerOrLambda;
        this.qualifierConstraints = GraphBuilder.directed().build();
        this.qualifierConstraints.putEdge((Object)ProperInferenceVar.BOTTOM, (Object)ProperInferenceVar.NONNULL);
        this.qualifierConstraints.putEdge((Object)ProperInferenceVar.BOTTOM, (Object)ProperInferenceVar.NULL);
        this.qualifierConstraints.putEdge((Object)ProperInferenceVar.NONNULL, (Object)ProperInferenceVar.NULLABLE);
        this.qualifierConstraints.putEdge((Object)ProperInferenceVar.NULL, (Object)ProperInferenceVar.NULLABLE);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void unused) {
        Type declaredType = ((JCTree.JCIdent)node).sym.type;
        this.generateConstraintsFromIdentifierUse(declaredType, node, new ArrayDeque<Integer>());
        return (Void)super.visitIdentifier(node, unused);
    }

    private void generateConstraintsFromIdentifierUse(Type type, Tree sourceTree, ArrayDeque<Integer> argSelector) {
        List<Type> typeArguments = type.getTypeArguments();
        int numberOfTypeArgs = typeArguments.size();
        for (int i = 0; i < numberOfTypeArgs; ++i) {
            argSelector.push(i);
            this.generateConstraintsFromIdentifierUse((Type)typeArguments.get(i), sourceTree, argSelector);
            argSelector.pop();
        }
        ProperInferenceVar.fromTypeIfAnnotated(type).ifPresent(annot -> {
            this.qualifierConstraints.putEdge((Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.copyOf((Collection)argSelector), sourceTree), annot);
            this.qualifierConstraints.putEdge(annot, (Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.copyOf((Collection)argSelector), sourceTree));
        });
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void unused) {
        Type lhsType = node.getVariable() instanceof ArrayAccessTree ? ((JCTree.JCArrayAccess)node.getVariable()).getExpression().type : TreeInfo.symbol((JCTree)((JCTree)((Object)node.getVariable()))).type;
        this.generateConstraintsForWrite(lhsType, node.getExpression(), node);
        return (Void)super.visitAssignment(node, unused);
    }

    @Override
    public Void visitVariable(VariableTree node, Void unused) {
        if (node.getInitializer() != null) {
            this.generateConstraintsForWrite(TreeInfo.symbolFor((JCTree)((JCTree)((Object)node))).type, node.getInitializer(), node);
        }
        return (Void)super.visitVariable(node, unused);
    }

    @Override
    public Void visitReturn(ReturnTree node, Void unused) {
        if (node.getExpression() != null && this.currentMethodOrInitializerOrLambda instanceof MethodTree) {
            Type returnType = ((Symbol.MethodSymbol)TreeInfo.symbolFor((JCTree)this.currentMethodOrInitializerOrLambda)).getReturnType();
            this.generateConstraintsForWrite(returnType, node.getExpression(), node);
        }
        return (Void)super.visitReturn(node, unused);
    }

    private static ImmutableList<Type> expandVarargsToArity(java.util.List<Symbol.VarSymbol> formalArgs, int arity) {
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)arity);
        int numberOfVarArgs = arity - formalArgs.size() + 1;
        Iterator<Symbol.VarSymbol> argsIterator = formalArgs.iterator();
        while (argsIterator.hasNext()) {
            Symbol.VarSymbol arg = argsIterator.next();
            if (argsIterator.hasNext()) {
                result.add((Object)arg.type);
                continue;
            }
            Type varArgType = ((Type.ArrayType)arg.type).elemtype;
            for (int idx = 0; idx < numberOfVarArgs; ++idx) {
                result.add((Object)varArgType);
            }
        }
        return result.build();
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
        JCTree.JCMethodInvocation sourceNode = (JCTree.JCMethodInvocation)node;
        Symbol.MethodSymbol callee = (Symbol.MethodSymbol)TreeInfo.symbol(sourceNode.getMethodSelect());
        ImmutableList formalParameters = callee.isVarArgs() ? NullnessQualifierInference.expandVarargsToArity(callee.getParameters(), sourceNode.args.size()) : (ImmutableList)callee.getParameters().stream().map(var -> var.type).collect(ImmutableList.toImmutableList());
        Streams.forEachPair((Stream)formalParameters.stream(), sourceNode.getArguments().stream(), (formal, actual) -> {
            this.generateConstraintsForWrite((Type)formal, (ExpressionTree)actual, node);
            this.generateConstraintsForWrite(actual.type, (ExpressionTree)actual, node);
        });
        if (node.getMethodSelect() instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node.getMethodSelect();
            for (Symbol.TypeVariableSymbol tvs : fieldAccess.selected.type.tsym.getTypeParameters()) {
                Type rcvrtype = fieldAccess.selected.type.tsym.type;
                ImmutableSet<InferenceVariable> rcvrReferences = NullnessQualifierInference.getReferencesToTypeVar(tvs, rcvrtype, fieldAccess.selected);
                Type restype = fieldAccess.sym.type.asMethodType().restype;
                NullnessQualifierInference.getReferencesToTypeVar(tvs, restype, node).forEach(resRef -> rcvrReferences.forEach(rcvrRef -> this.qualifierConstraints.putEdge(resRef, rcvrRef)));
                Streams.forEachPair((Stream)formalParameters.stream(), node.getArguments().stream(), (formal, actual) -> NullnessQualifierInference.getReferencesToTypeVar(tvs, formal, actual).forEach(argRef -> rcvrReferences.forEach(rcvrRef -> this.qualifierConstraints.putEdge(argRef, rcvrRef))));
            }
        }
        for (Symbol.TypeVariableSymbol typeVar : callee.getTypeParameters()) {
            InferenceVariable typeVarIV = TypeVariableInferenceVar.create(typeVar, node);
            for (InferenceVariable iv : NullnessQualifierInference.getReferencesToTypeVar(typeVar, callee.getReturnType(), node)) {
                this.qualifierConstraints.putEdge((Object)typeVarIV, (Object)iv);
            }
            Streams.forEachPair((Stream)formalParameters.stream(), node.getArguments().stream(), (formal, actual) -> {
                for (InferenceVariable iv : NullnessQualifierInference.getReferencesToTypeVar(typeVar, formal, actual)) {
                    this.qualifierConstraints.putEdge((Object)iv, (Object)typeVarIV);
                }
            });
        }
        return (Void)super.visitMethodInvocation(node, unused);
    }

    private static ImmutableSet<InferenceVariable> getReferencesToTypeVar(Symbol.TypeVariableSymbol typeVar, Type type, Tree sourceNode) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        NullnessQualifierInference.getTypeVarReferences(typeVar, sourceNode, type, new ArrayDeque<Integer>(), (ImmutableSet.Builder<InferenceVariable>)result);
        return result.build();
    }

    private static void getTypeVarReferences(Symbol.TypeVariableSymbol typeVar, Tree sourceNode, Type type, ArrayDeque<Integer> partialSelector, ImmutableSet.Builder<InferenceVariable> resultBuilder) {
        List<Type> typeArguments = type.getTypeArguments();
        for (int i = 0; i < typeArguments.size(); ++i) {
            partialSelector.push(i);
            NullnessQualifierInference.getTypeVarReferences(typeVar, sourceNode, (Type)typeArguments.get(i), partialSelector, resultBuilder);
            partialSelector.pop();
        }
        if (type.tsym.equals(typeVar)) {
            resultBuilder.add((Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.copyOf(partialSelector), sourceNode));
        }
    }

    private void generateConstraintsForWrite(Type lType, ExpressionTree rVal, Tree sourceTree) {
        if (rVal.getKind() == Tree.Kind.NULL_LITERAL) {
            this.qualifierConstraints.putEdge((Object)ProperInferenceVar.NULL, (Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.of(), sourceTree));
        } else if (rVal instanceof LiteralTree || rVal instanceof NewClassTree || rVal instanceof NewArrayTree || rVal instanceof IdentifierTree && ((IdentifierTree)rVal).getName().contentEquals("this")) {
            this.qualifierConstraints.putEdge((Object)ProperInferenceVar.NONNULL, (Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.of(), sourceTree));
        }
        this.generateConstraintsForWrite(lType, rVal, sourceTree, new ArrayDeque<Integer>());
    }

    private void generateConstraintsForWrite(Type lType, ExpressionTree rVal, Tree sourceTree, ArrayDeque<Integer> argSelector) {
        List<Type> typeArguments = lType.getTypeArguments();
        for (int i = 0; i < typeArguments.size(); ++i) {
            argSelector.push(i);
            this.generateConstraintsForWrite((Type)typeArguments.get(i), rVal, sourceTree, argSelector);
            argSelector.pop();
        }
        ImmutableList argSelectorList = ImmutableList.copyOf(argSelector);
        ProperInferenceVar.fromTypeIfAnnotated(lType).ifPresent(annot -> {
            this.qualifierConstraints.putEdge((Object)TypeArgInferenceVar.create((ImmutableList<Integer>)argSelectorList, sourceTree), annot);
            this.qualifierConstraints.putEdge(annot, (Object)TypeArgInferenceVar.create((ImmutableList<Integer>)argSelectorList, sourceTree));
        });
        this.qualifierConstraints.putEdge((Object)TypeArgInferenceVar.create((ImmutableList<Integer>)argSelectorList, rVal), (Object)TypeArgInferenceVar.create((ImmutableList<Integer>)argSelectorList, sourceTree));
    }
}

