/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.trace;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AttributeValue {
    private final String stringValue;
    private final Boolean booleanValue;
    private final Long longValue;

    public static AttributeValue stringAttributeValue(String stringValue) {
        return new AttributeValue((String)Preconditions.checkNotNull((Object)stringValue, (Object)"stringValue"), null, null);
    }

    public static AttributeValue booleanAttributeValue(boolean booleanValue) {
        return new AttributeValue(null, booleanValue, null);
    }

    public static AttributeValue longAttributeValue(long longValue) {
        return new AttributeValue(null, null, longValue);
    }

    private AttributeValue(@Nullable String stringValue, @Nullable Boolean booleanValue, @Nullable Long longValue) {
        this.stringValue = stringValue;
        this.booleanValue = booleanValue;
        this.longValue = longValue;
    }

    @Nullable
    public String getStringValue() {
        return this.stringValue;
    }

    @Nullable
    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    @Nullable
    public Long getLongValue() {
        return this.longValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue that = (AttributeValue)obj;
        return Objects.equal((Object)this.stringValue, (Object)that.stringValue) && Objects.equal((Object)this.booleanValue, (Object)that.booleanValue) && Objects.equal((Object)this.longValue, (Object)that.longValue);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.stringValue, this.booleanValue, this.longValue});
    }

    public String toString() {
        if (this.getStringValue() != null) {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)"string").add("value", (Object)this.getStringValue()).toString();
        }
        if (this.getBooleanValue() != null) {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)"boolean").add("value", (Object)this.getBooleanValue()).toString();
        }
        if (this.getLongValue() != null) {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)"long").add("value", (Object)this.getLongValue()).toString();
        }
        throw new RuntimeException("Not a supported attribute value");
    }
}

