/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.concurrent.LockMethod;
import com.google.errorprone.bugpatterns.threadsafety.AbstractLockMethodChecker;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.HeldLockAnalyzer;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Set;

@BugPattern(name="LockMethodChecker", altNames={"GuardedBy"}, summary="This method does not acquire the locks specified by its @LockMethod annotation", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class LockMethodChecker
extends AbstractLockMethodChecker {
    @Override
    protected ImmutableList<String> getLockExpressions(MethodTree tree) {
        LockMethod lockMethod = (LockMethod)ASTHelpers.getAnnotation((Tree)tree, LockMethod.class);
        return lockMethod == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])lockMethod.value());
    }

    @Override
    protected Set<GuardedByExpression> getActual(MethodTree tree, VisitorState state) {
        return ImmutableSet.copyOf(HeldLockAnalyzer.AcquiredLockFinder.find(tree.getBody(), state));
    }

    @Override
    protected Set<GuardedByExpression> getUnwanted(MethodTree tree, VisitorState state) {
        return ImmutableSet.copyOf(HeldLockAnalyzer.ReleasedLockFinder.find(tree.getBody(), state));
    }

    @Override
    protected String buildMessage(String unhandled) {
        return "The following locks are specifed in this method's @LockMethod annotation but are not acquired: " + unhandled;
    }
}

