/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.ConstructorLeakChecker;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Name;

@BugPattern(name="ConstructorLeaksThis", summary="Constructors should not pass the 'this' reference out in method invocations, since the object may not be fully constructed.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class ConstructorLeaksThis
extends ConstructorLeakChecker {
    @Override
    protected void traverse(Tree tree, final VisitorState state) {
        final Symbol.ClassSymbol thisClass = ASTHelpers.getSymbol((ClassTree)((ClassTree)state.findEnclosing(new Class[]{ClassTree.class})));
        tree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void unused) {
                ConstructorLeaksThis.this.checkForThis(node, node.getName(), thisClass, state);
                return (Void)super.visitIdentifier(node, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void unused) {
                ConstructorLeaksThis.this.checkForThis(node, node.getIdentifier(), thisClass, state);
                ExpressionTree left = node.getExpression();
                if (left instanceof IdentifierTree && ((IdentifierTree)left).getName().contentEquals("this") || left instanceof MemberSelectTree && ((MemberSelectTree)left).getIdentifier().contentEquals("this")) {
                    return null;
                }
                return (Void)super.visitMemberSelect(node, unused);
            }

            @Override
            public Void visitAssignment(AssignmentTree node, Void unused) {
                this.scan(node.getExpression(), null);
                return null;
            }
        }, null);
    }

    private void checkForThis(ExpressionTree node, Name identifier, Symbol.ClassSymbol thisClass, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)node);
        if (sym != null && !sym.isConstructor() && identifier.contentEquals("this") && thisClass.equals(sym.owner)) {
            state.reportMatch(this.describeMatch(node));
        }
    }
}

