/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;

public interface StatisticsCollector {
    default public void incrementCounter(String key) {
        this.incrementCounter(key, 1);
    }

    public void incrementCounter(String var1, int var2);

    public ImmutableMultiset<String> counters();

    public static StatisticsCollector createCollector() {
        return new StatisticsCollector(){
            private final Multiset<String> strings = HashMultiset.create();

            @Override
            public void incrementCounter(String key, int count) {
                this.strings.add((Object)key, count);
            }

            @Override
            public ImmutableMultiset<String> counters() {
                return ImmutableMultiset.copyOf(this.strings);
            }
        };
    }

    public static StatisticsCollector createNoOpCollector() {
        return new StatisticsCollector(){

            @Override
            public void incrementCounter(String key, int count) {
            }

            @Override
            public ImmutableMultiset<String> counters() {
                return ImmutableMultiset.of();
            }
        };
    }
}

