/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repositoryv2;

import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.utils.ILogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LoggerProgressIndicatorWrapper
extends ProgressIndicatorAdapter {
    private final ILogger mWrapped;

    public LoggerProgressIndicatorWrapper(ILogger toWrap) {
        this.mWrapped = toWrap;
    }

    public void logWarning(String s) {
        this.mWrapped.warning(s, new Object[0]);
    }

    public void logWarning(String s, Throwable e) {
        if (e == null) {
            this.logWarning(s);
            return;
        }
        this.mWrapped.warning("%1$s:\n%2$s", new Object[]{s, LoggerProgressIndicatorWrapper.throwableToString(e)});
    }

    public void logError(String s) {
        this.logError(s, null);
    }

    public void logError(String s, Throwable e) {
        this.mWrapped.error(e, s, new Object[0]);
    }

    public void logInfo(String s) {
        this.mWrapped.info(s, new Object[0]);
    }

    private static String throwableToString(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

