/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.refaster.AutoValue_RefasterScanner;
import com.google.errorprone.refaster.RefasterRule;
import com.google.errorprone.refaster.Template;
import com.google.errorprone.refaster.TemplateMatch;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import java.nio.CharBuffer;

@AutoValue
abstract class RefasterScanner<M extends TemplateMatch, T extends Template<M>>
extends TreeScanner<Void, Context> {
    private static final SimpleTreeVisitor<Tree, Void> SKIP_PARENS = new SimpleTreeVisitor<Tree, Void>(){

        @Override
        public Tree visitParenthesized(ParenthesizedTree node, Void v) {
            return node.getExpression().accept(this, null);
        }

        @Override
        protected Tree defaultAction(Tree node, Void v) {
            return node;
        }
    };

    RefasterScanner() {
    }

    static <M extends TemplateMatch, T extends Template<M>> RefasterScanner<M, T> create(RefasterRule<M, T> rule, DescriptionListener listener) {
        return new AutoValue_RefasterScanner<M, T>(rule, listener);
    }

    abstract RefasterRule<M, T> rule();

    abstract DescriptionListener listener();

    @Override
    public Void visitClass(ClassTree node, Context context) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)node);
        if (sym == null || !((Symbol)sym).getQualifiedName().contentEquals(this.rule().qualifiedTemplateClass())) {
            ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
            for (Tree tree : node.getMembers()) {
                if (tree instanceof JCTree.JCStatement) {
                    statements.append((JCTree.JCStatement)tree);
                    continue;
                }
                tree.accept(this, context);
            }
            this.scan((Tree)TreeMaker.instance(context).Block(0L, statements.toList()), context);
        }
        return null;
    }

    @Override
    public Void scan(Tree tree, Context context) {
        if (tree == null) {
            return null;
        }
        JCTree.JCCompilationUnit compilationUnit = context.get(JCTree.JCCompilationUnit.class);
        for (Template beforeTemplate : this.rule().beforeTemplates()) {
            block1: for (TemplateMatch match : beforeTemplate.match((JCTree)tree, context)) {
                if (this.rule().rejectMatchesWithComments()) {
                    String matchContents = match.getRange(compilationUnit);
                    JavaTokenizer tokenizer = new JavaTokenizer(ScannerFactory.instance(context), CharBuffer.wrap(matchContents)){};
                    Tokens.Token token = tokenizer.readToken();
                    while (token.kind != Tokens.TokenKind.EOF) {
                        if (token.comments != null && !token.comments.isEmpty()) continue block1;
                        token = tokenizer.readToken();
                    }
                }
                Description.Builder builder = Description.builder((JCTree)match.getLocation(), (String)this.rule().qualifiedTemplateClass(), (String)"", (BugPattern.SeverityLevel)BugPattern.SeverityLevel.WARNING, (String)"");
                if (this.rule().afterTemplates().isEmpty()) {
                    builder.addFix((Fix)SuggestedFix.prefixWith((Tree)match.getLocation(), (String)"/* match found */ "));
                } else {
                    for (Template afterTemplate : this.rule().afterTemplates()) {
                        builder.addFix(afterTemplate.replace(match));
                    }
                }
                this.listener().onDescribed(builder.build());
            }
        }
        return (Void)super.scan(tree, context);
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, Context context) {
        this.scan((Tree)node.getStatement(), context);
        this.scan(SKIP_PARENS.visit(node.getCondition(), null), context);
        return null;
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree node, Context context) {
        this.scan(SKIP_PARENS.visit(node.getCondition(), null), context);
        this.scan((Tree)node.getStatement(), context);
        return null;
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Context context) {
        this.scan(SKIP_PARENS.visit(node.getExpression(), null), context);
        this.scan((Tree)node.getBlock(), context);
        return null;
    }

    @Override
    public Void visitIf(IfTree node, Context context) {
        this.scan(SKIP_PARENS.visit(node.getCondition(), null), context);
        this.scan((Tree)node.getThenStatement(), context);
        this.scan((Tree)node.getElseStatement(), context);
        return null;
    }
}

