/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BugPattern(name="DurationToLongTimeUnit", summary="Unit mismatch when decomposing a Duration or Instant to call a <long, TimeUnit> API", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class DurationToLongTimeUnit
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String JAVA_DURATION = "java.time.Duration";
    private static final String JAVA_INSTANT = "java.time.Instant";
    private static final String JODA_DURATION = "org.joda.time.Duration";
    private static final String JODA_RDURATION = "org.joda.time.ReadableDuration";
    private static final String JODA_RINSTANT = "org.joda.time.ReadableInstant";
    private static final String PROTO_DURATION = "com.google.protobuf.Duration";
    private static final String PROTO_TIMESTAMP = "com.google.protobuf.Timestamp";
    private static final String TIME_UNIT = "java.util.concurrent.TimeUnit";
    private static final ImmutableMap<Matcher<ExpressionTree>, TimeUnit> MATCHERS = new ImmutableMap.Builder().put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toNanos"), (Object)TimeUnit.NANOSECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toMillis"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("getSeconds"), (Object)TimeUnit.SECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toMinutes"), (Object)TimeUnit.MINUTES).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toHours"), (Object)TimeUnit.HOURS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toDays"), (Object)TimeUnit.DAYS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Instant").named("toEpochMilli"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Instant").named("getEpochSecond"), (Object)TimeUnit.SECONDS).put((Object)Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("getStandardSeconds"), (Object)TimeUnit.SECONDS).put((Object)Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("getStandardMinutes"), (Object)TimeUnit.MINUTES).put((Object)Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("getStandardHours"), (Object)TimeUnit.HOURS).put((Object)Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("getStandardDays"), (Object)TimeUnit.DAYS).put((Object)Matchers.instanceMethod().onDescendantOf("org.joda.time.ReadableDuration").named("getMillis"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onDescendantOf("org.joda.time.ReadableInstant").named("getMillis"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onExactClass("com.google.protobuf.Duration").named("getSeconds"), (Object)TimeUnit.SECONDS).put((Object)Matchers.instanceMethod().onExactClass("com.google.protobuf.Timestamp").named("getSeconds"), (Object)TimeUnit.SECONDS).build();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() >= 2) {
            for (int i = 0; i < arguments.size() - 1; ++i) {
                Optional<TimeUnit> timeUnit;
                Type type0 = ASTHelpers.getType((Tree)arguments.get(i));
                Type type1 = ASTHelpers.getType((Tree)arguments.get(i + 1));
                Type.JCPrimitiveType longType = state.getSymtab().longType;
                Type timeUnitType = state.getTypeFromString(TIME_UNIT);
                if (!ASTHelpers.isSameType((Type)type0, (Type)longType, (VisitorState)state) || !ASTHelpers.isSameType((Type)type1, (Type)timeUnitType, (VisitorState)state) || !(timeUnit = DurationToLongTimeUnit.getTimeUnit(arguments.get(i + 1))).isPresent()) continue;
                ExpressionTree arg0 = arguments.get(i);
                for (Map.Entry entry : MATCHERS.entrySet()) {
                    TimeUnit correctTimeUnit = (TimeUnit)((Object)entry.getValue());
                    if (!((Matcher)entry.getKey()).matches((Tree)arg0, state) || timeUnit.get() == correctTimeUnit) continue;
                    SuggestedFix fix = SuggestedFix.builder().addImport(TIME_UNIT).replace((Tree)arguments.get(i + 1), "TimeUnit." + (Object)((Object)correctTimeUnit)).build();
                    return this.describeMatch(tree, (Fix)fix);
                }
            }
        }
        return Description.NO_MATCH;
    }

    private static Optional<TimeUnit> getTimeUnit(ExpressionTree timeUnit) {
        if (timeUnit instanceof IdentifierTree) {
            return Enums.getIfPresent(TimeUnit.class, (String)((IdentifierTree)timeUnit).getName().toString());
        }
        if (timeUnit instanceof MemberSelectTree) {
            return Enums.getIfPresent(TimeUnit.class, (String)((MemberSelectTree)timeUnit).getIdentifier().toString());
        }
        return Optional.absent();
    }
}

