/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="TypeEquals", summary="com.sun.tools.javac.code.Type doesn't override Object.equals and instances are not interned by javac, so testing types for equality should be done with Types#isSameType instead", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.NO_FIX)
public class TypeEqualsChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> TYPE_EQUALS = MethodMatchers.instanceMethod().onDescendantOf("javax.lang.model.type.TypeMirror").named("equals");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!TYPE_EQUALS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

