/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Converter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.Objects;

@BugPattern(name="CanonicalDuration", summary="Duration can be expressed more clearly with different units", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class CanonicalDuration
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> JAVA_TIME_MATCHER = MethodMatchers.staticMethod().onClass(Api.JAVA.getDurationFullyQualifiedName());
    private static final Matcher<ExpressionTree> JODA_MATCHER = MethodMatchers.staticMethod().onClass(Api.JODA.getDurationFullyQualifiedName());
    private static final ImmutableTable<Api, ChronoUnit, String> FACTORIES = ImmutableTable.builder().put((Object)Api.JAVA, (Object)ChronoUnit.DAYS, (Object)"ofDays").put((Object)Api.JAVA, (Object)ChronoUnit.HOURS, (Object)"ofHours").put((Object)Api.JAVA, (Object)ChronoUnit.MINUTES, (Object)"ofMinutes").put((Object)Api.JAVA, (Object)ChronoUnit.SECONDS, (Object)"ofSeconds").put((Object)Api.JAVA, (Object)ChronoUnit.MILLIS, (Object)"ofMillis").put((Object)Api.JAVA, (Object)ChronoUnit.NANOS, (Object)"ofNanos").put((Object)Api.JODA, (Object)ChronoUnit.DAYS, (Object)"standardDays").put((Object)Api.JODA, (Object)ChronoUnit.HOURS, (Object)"standardHours").put((Object)Api.JODA, (Object)ChronoUnit.MINUTES, (Object)"standardMinutes").put((Object)Api.JODA, (Object)ChronoUnit.SECONDS, (Object)"standardSeconds").build();
    private static final ImmutableMap<String, TemporalUnit> METHOD_NAME_TO_UNIT = (ImmutableMap)FACTORIES.rowMap().values().stream().flatMap(x -> x.entrySet().stream()).collect(ImmutableMap.toImmutableMap(x -> (String)x.getValue(), x -> (ChronoUnit)x.getKey()));
    private static final ImmutableMap<ChronoUnit, Converter<Duration, Long>> CONVERTERS = ImmutableMap.builder().put((Object)ChronoUnit.DAYS, (Object)Converter.from(Duration::toDays, Duration::ofDays)).put((Object)ChronoUnit.HOURS, (Object)Converter.from(Duration::toHours, Duration::ofHours)).put((Object)ChronoUnit.MINUTES, (Object)Converter.from(Duration::toMinutes, Duration::ofMinutes)).put((Object)ChronoUnit.SECONDS, (Object)Converter.from(Duration::getSeconds, Duration::ofSeconds)).put((Object)ChronoUnit.MILLIS, (Object)Converter.from(Duration::toMillis, Duration::ofMillis)).put((Object)ChronoUnit.NANOS, (Object)Converter.from(Duration::toNanos, Duration::ofNanos)).build();
    private static final ImmutableMap<TemporalUnit, Long> BANLIST = ImmutableMap.of((Object)ChronoUnit.HOURS, (Object)24L, (Object)ChronoUnit.MINUTES, (Object)60L, (Object)ChronoUnit.SECONDS, (Object)60L);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Map.Entry entry;
        ChronoUnit nextUnit;
        Api api;
        if (JAVA_TIME_MATCHER.matches((Tree)tree, state)) {
            api = Api.JAVA;
        } else if (JODA_MATCHER.matches((Tree)tree, state)) {
            api = Api.JODA;
        } else {
            return Description.NO_MATCH;
        }
        if (tree.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        Tree arg = (Tree)Iterables.getOnlyElement(tree.getArguments());
        if (!(arg instanceof LiteralTree)) {
            return Description.NO_MATCH;
        }
        Number constValue = (Number)ASTHelpers.constValue((Tree)arg, Number.class);
        if (constValue == null) {
            return Description.NO_MATCH;
        }
        long value = constValue.longValue();
        if (value == 0L) {
            switch (api) {
                case JODA: {
                    ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
                    SuggestedFix fix = receiver == null ? SuggestedFix.builder().addImport(api.getDurationFullyQualifiedName()).replace((Tree)tree, "Duration.ZERO").build() : SuggestedFix.replace((int)state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), (int)state.getEndPosition((Tree)tree), (String)".ZERO");
                    return this.buildDescription(tree).setMessage("Duration can be expressed more clearly without units, as Duration.ZERO").addFix((Fix)fix).build();
                }
                case JAVA: {
                    return Description.NO_MATCH;
                }
            }
            throw new AssertionError((Object)api);
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (!METHOD_NAME_TO_UNIT.containsKey((Object)((Name)sym.getSimpleName()).toString())) {
            return Description.NO_MATCH;
        }
        TemporalUnit unit = (TemporalUnit)METHOD_NAME_TO_UNIT.get((Object)((Name)sym.getSimpleName()).toString());
        if (Objects.equals(BANLIST.get((Object)unit), value)) {
            return Description.NO_MATCH;
        }
        Duration duration = Duration.of(value, unit);
        UnmodifiableIterator unmodifiableIterator = CONVERTERS.entrySet().iterator();
        while (unmodifiableIterator.hasNext() && !unit.equals(nextUnit = (ChronoUnit)(entry = (Map.Entry)unmodifiableIterator.next()).getKey())) {
            Converter converter = (Converter)entry.getValue();
            long nextValue = (Long)converter.convert((Object)duration);
            if (!((Duration)converter.reverse().convert((Object)nextValue)).equals(duration)) continue;
            String name = (String)FACTORIES.get((Object)api, (Object)nextUnit);
            String replacement = String.format("%s(%d%s)", name, nextValue, nextValue == (long)((int)nextValue) ? "" : "L");
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            if (receiver == null) {
                SuggestedFix fix = SuggestedFix.builder().addStaticImport(api.getDurationFullyQualifiedName() + "." + name).replace((Tree)tree, replacement).build();
                return this.describeMatch(tree, (Fix)fix);
            }
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)receiver), (int)state.getEndPosition((Tree)tree), (String)("." + replacement)));
        }
        return Description.NO_MATCH;
    }

    static enum Api {
        JAVA("java.time.Duration"),
        JODA("org.joda.time.Duration");

        private final String durationFullyQualifiedName;

        private Api(String durationFullyQualifiedName) {
            this.durationFullyQualifiedName = durationFullyQualifiedName;
        }

        String getDurationFullyQualifiedName() {
            return this.durationFullyQualifiedName;
        }
    }
}

