/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.doclint.HtmlVersion;
import com.sun.tools.doclint.Messages;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.MatchingUtils;
import com.sun.tools.javac.util.StringUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class Env {
    final Messages messages;
    int implicitHeaderLevel = 0;
    Set<String> customTags;
    Set<Pattern> includePackages;
    Set<Pattern> excludePackages;
    HtmlVersion htmlVersion = HtmlVersion.HTML4;
    DocTrees trees;
    Elements elements;
    Types types;
    TypeMirror java_lang_Error;
    TypeMirror java_lang_RuntimeException;
    TypeMirror java_lang_Throwable;
    TypeMirror java_lang_Void;
    TreePath currPath;
    Element currElement;
    DocCommentTree currDocComment;
    AccessKind currAccess;
    Set<? extends ExecutableElement> currOverriddenMethods;

    Env() {
        this.messages = new Messages(this);
    }

    void init(JavacTask task) {
        this.init(DocTrees.instance(task), task.getElements(), task.getTypes());
    }

    void init(DocTrees trees, Elements elements, Types types) {
        this.trees = trees;
        this.elements = elements;
        this.types = types;
    }

    void initTypes() {
        if (this.java_lang_Error != null) {
            return;
        }
        this.java_lang_Error = this.elements.getTypeElement("java.lang.Error").asType();
        this.java_lang_RuntimeException = this.elements.getTypeElement("java.lang.RuntimeException").asType();
        this.java_lang_Throwable = this.elements.getTypeElement("java.lang.Throwable").asType();
        this.java_lang_Void = this.elements.getTypeElement("java.lang.Void").asType();
    }

    void setImplicitHeaders(int n) {
        this.implicitHeaderLevel = n;
    }

    void setCustomTags(String cTags) {
        this.customTags = new LinkedHashSet<String>();
        for (String s : cTags.split(",")) {
            if (s.isEmpty()) continue;
            this.customTags.add(s);
        }
    }

    void setCheckPackages(String packages) {
        this.includePackages = new HashSet<Pattern>();
        this.excludePackages = new HashSet<Pattern>();
        for (String pack : packages.split(",")) {
            boolean excluded = false;
            if (pack.startsWith("-")) {
                pack = pack.substring(1);
                excluded = true;
            }
            if (pack.isEmpty()) continue;
            Pattern pattern = MatchingUtils.validImportStringToPattern(pack);
            if (excluded) {
                this.excludePackages.add(pattern);
                continue;
            }
            this.includePackages.add(pattern);
        }
    }

    static boolean validatePackages(String packages) {
        for (String pack : packages.split(",")) {
            if (pack.startsWith("-")) {
                pack = pack.substring(1);
            }
            if (pack.isEmpty() || MatchingUtils.isValidImportString(pack)) continue;
            return false;
        }
        return true;
    }

    void setHtmlVersion(HtmlVersion version) {
        this.htmlVersion = version;
    }

    void setCurrent(TreePath path, DocCommentTree comment) {
        this.currPath = path;
        this.currDocComment = comment;
        this.currElement = this.trees.getElement(this.currPath);
        this.currOverriddenMethods = ((JavacTypes)this.types).getOverriddenMethods(this.currElement);
        AccessKind ak = AccessKind.PUBLIC;
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            Element e = this.trees.getElement(p);
            if (e == null || e.getKind() == ElementKind.PACKAGE || e.getKind() == ElementKind.MODULE) continue;
            ak = this.min(ak, AccessKind.of(e.getModifiers()));
        }
        this.currAccess = ak;
    }

    AccessKind getAccessKind() {
        return this.currAccess;
    }

    long getPos(TreePath p) {
        return ((JCTree)p.getLeaf()).pos;
    }

    long getStartPos(TreePath p) {
        DocSourcePositions sp = this.trees.getSourcePositions();
        return sp.getStartPosition(p.getCompilationUnit(), p.getLeaf());
    }

    boolean shouldCheck(CompilationUnitTree unit) {
        String packageName;
        if (this.includePackages == null) {
            return true;
        }
        String string = packageName = unit.getPackageName() != null ? unit.getPackageName().toString() : "";
        if (!this.includePackages.isEmpty()) {
            boolean included = false;
            for (Pattern pack : this.includePackages) {
                if (!pack.matcher(packageName).matches()) continue;
                included = true;
                break;
            }
            if (!included) {
                return false;
            }
        }
        for (Pattern pack : this.excludePackages) {
            if (!pack.matcher(packageName).matches()) continue;
            return false;
        }
        return true;
    }

    private <T extends Comparable<T>> T min(T item1, T item2) {
        return item1 == null ? item2 : (item2 == null ? item1 : (item1.compareTo(item2) <= 0 ? item1 : item2));
    }

    public static enum AccessKind {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC;


        static boolean accepts(String opt) {
            for (AccessKind g : AccessKind.values()) {
                if (!opt.equals(StringUtils.toLowerCase(g.name()))) continue;
                return true;
            }
            return false;
        }

        static AccessKind of(Set<Modifier> mods) {
            if (mods.contains((Object)Modifier.PUBLIC)) {
                return PUBLIC;
            }
            if (mods.contains((Object)Modifier.PROTECTED)) {
                return PROTECTED;
            }
            if (mods.contains((Object)Modifier.PRIVATE)) {
                return PRIVATE;
            }
            return PACKAGE;
        }
    }
}

