/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp.dependencies;

import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.comp.PubAPIs;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public class PublicApiCollector
implements TaskListener {
    private Context context;
    private final Set<Symbol.ClassSymbol> classSymbols = new HashSet<Symbol.ClassSymbol>();
    private final Collection<JavaFileObject> explicitJFOs;
    private Map<String, PubApi> explicitPubApis;
    private Map<String, PubApi> nonExplicitPubApis;

    public PublicApiCollector(Context context, Collection<JavaFileObject> collection) {
        this.context = context;
        this.explicitJFOs = collection;
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        switch (taskEvent.getKind()) {
            case ANALYZE: {
                this.collectClassSymbols((JCTree.JCCompilationUnit)taskEvent.getCompilationUnit());
                break;
            }
            case COMPILATION: {
                Log.debug("Compilation finished");
                Log.debug("Extracting pub APIs for the following symbols:");
                for (Symbol.ClassSymbol classSymbol : this.classSymbols) {
                    Log.debug("    " + classSymbol.fullname);
                }
                this.extractPubApis();
                PubAPIs pubAPIs = PubAPIs.instance(this.context);
                this.explicitPubApis = pubAPIs.getPubapis(this.explicitJFOs, true);
                this.nonExplicitPubApis = pubAPIs.getPubapis(this.explicitJFOs, false);
                Log.debug("done");
            }
        }
    }

    private void collectClassSymbols(JCTree.JCCompilationUnit jCCompilationUnit) {
        for (Tree tree : jCCompilationUnit.getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            this.classSymbols.add(((JCTree.JCClassDecl)tree).sym);
        }
    }

    private void extractPubApis() {
        PubAPIs pubAPIs = PubAPIs.instance(this.context);
        this.classSymbols.forEach(pubAPIs::visitPubapi);
    }

    public Map<String, PubApi> getPubApis(boolean bl) {
        return bl ? this.explicitPubApis : this.nonExplicitPubApis;
    }
}

