/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.PooledSjavac;
import com.sun.tools.sjavac.comp.SjavacImpl;
import com.sun.tools.sjavac.server.IdleResetSjavac;
import com.sun.tools.sjavac.server.PortFile;
import com.sun.tools.sjavac.server.PortFileMonitor;
import com.sun.tools.sjavac.server.RequestHandler;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.Terminable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public class SjavacServer
implements Terminable {
    public static final String CMD_COMPILE = "compile";
    public static final String CMD_SYS_INFO = "sys-info";
    private final String portfilename;
    private final String logfile;
    private final String stdouterrfile;
    private final int poolsize;
    private final int keepalive;
    private final PrintStream err;
    private final long myCookie;
    private long totalBuildTime;
    PrintWriter theLog;
    Sjavac sjavac;
    private ServerSocket serverSocket;
    private PortFile portFile;
    private PortFileMonitor portFileMonitor;
    final AtomicBoolean keepAcceptingRequests = new AtomicBoolean();
    private static Map<String, PortFile> allPortFiles;
    private static Map<String, Long> maxServerMemory;

    public SjavacServer(String settings, PrintStream err) throws FileNotFoundException {
        this(Util.extractStringOption("portfile", settings), Util.extractStringOption("logfile", settings), Util.extractStringOption("stdouterrfile", settings), Util.extractIntOption("poolsize", settings, Runtime.getRuntime().availableProcessors()), Util.extractIntOption("keepalive", settings, 120), err);
    }

    public SjavacServer(String portfilename, String logfile, String stdouterrfile, int poolsize, int keepalive, PrintStream err) throws FileNotFoundException {
        this.portfilename = portfilename;
        this.logfile = logfile;
        this.stdouterrfile = stdouterrfile;
        this.poolsize = poolsize;
        this.keepalive = keepalive;
        this.err = err;
        this.myCookie = new Random().nextLong();
        this.theLog = new PrintWriter(logfile);
    }

    public static synchronized PortFile getPortFile(String filename) throws FileNotFoundException {
        PortFile pf;
        if (allPortFiles == null) {
            allPortFiles = new HashMap<String, PortFile>();
        }
        if ((pf = allPortFiles.get(filename)) != null) {
            try {
                if (!pf.exists()) {
                    pf = null;
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
        if (pf == null) {
            pf = new PortFile(filename);
            allPortFiles.put(filename, pf);
        }
        return pf;
    }

    long getCookie() {
        return this.myCookie;
    }

    int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void addBuildTime(long inc) {
        this.totalBuildTime += inc;
    }

    public void log(String msg) {
        if (this.theLog != null) {
            this.theLog.println(msg);
        } else {
            System.err.println(msg);
        }
    }

    public void flushLog() {
        if (this.theLog != null) {
            this.theLog.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startServer() throws IOException, InterruptedException {
        long serverStart = System.currentTimeMillis();
        PortFile portFile = this.portFile = SjavacServer.getPortFile(this.portfilename);
        synchronized (portFile) {
            this.portFile.lock();
            this.portFile.getValues();
            if (this.portFile.containsPortInfo()) {
                this.err.println("Javac server not started because portfile exists!");
                this.portFile.unlock();
                return -1;
            }
            this.sjavac = new SjavacImpl();
            this.sjavac = new PooledSjavac(this.sjavac, this.poolsize);
            this.sjavac = new IdleResetSjavac(this.sjavac, this, this.keepalive * 1000);
            this.serverSocket = new ServerSocket();
            InetAddress localhost = InetAddress.getByName(null);
            this.serverSocket.bind(new InetSocketAddress(localhost, 0));
            this.portFile.setValues(this.getPort(), this.getCookie());
            this.portFile.unlock();
        }
        this.portFileMonitor = new PortFileMonitor(this.portFile, this);
        this.portFileMonitor.start();
        this.log("Sjavac server started. Accepting connections...");
        this.log("    port: " + this.getPort());
        this.log("    time: " + new Date());
        this.log("    poolsize: " + this.poolsize);
        this.flushLog();
        this.keepAcceptingRequests.set(true);
        do {
            try {
                Socket socket = this.serverSocket.accept();
                new Thread(new RequestHandler(socket, this.sjavac)).start();
            }
            catch (SocketException socket) {
                // empty catch block
            }
        } while (this.keepAcceptingRequests.get());
        this.log("Shutting down.");
        long realTime = System.currentTimeMillis() - serverStart;
        this.log("Total wall clock time " + realTime + "ms build time " + this.totalBuildTime + "ms");
        this.flushLog();
        this.sjavac.shutdown();
        return 0;
    }

    @Override
    public void shutdown(String quitMsg) {
        if (!this.keepAcceptingRequests.compareAndSet(true, false)) {
            return;
        }
        this.log("Quitting: " + quitMsg);
        this.flushLog();
        this.portFileMonitor.shutdown();
        try {
            this.portFile.delete();
        }
        catch (IOException e) {
            e.printStackTrace(this.theLog);
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace(this.theLog);
        }
    }
}

