/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.pubapi;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.StringUtils;
import com.sun.tools.sjavac.pubapi.ArrayTypeDesc;
import com.sun.tools.sjavac.pubapi.PrimitiveTypeDesc;
import com.sun.tools.sjavac.pubapi.ReferenceTypeDesc;
import com.sun.tools.sjavac.pubapi.TypeVarTypeDesc;
import java.io.Serializable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor9;

public abstract class TypeDesc
implements Serializable {
    private static final long serialVersionUID = -8201634143915519172L;
    TypeKind typeKind;

    public TypeDesc(TypeKind typeKind) {
        this.typeKind = typeKind;
    }

    public static TypeDesc decodeString(String s) {
        if ((s = s.trim()).endsWith("[]")) {
            String componentPart = s.substring(0, s.length() - 2);
            return new ArrayTypeDesc(TypeDesc.decodeString(componentPart));
        }
        if (s.startsWith("#")) {
            return new TypeVarTypeDesc(s.substring(1));
        }
        if (s.matches("boolean|byte|char|double|float|int|long|short|void")) {
            TypeKind tk = TypeKind.valueOf(StringUtils.toUpperCase(s));
            return new PrimitiveTypeDesc(tk);
        }
        return new ReferenceTypeDesc(s);
    }

    public static String encodeAsString(TypeDesc td) {
        if (td.typeKind.isPrimitive() || td.typeKind == TypeKind.VOID) {
            return StringUtils.toLowerCase(td.typeKind.toString());
        }
        if (td.typeKind == TypeKind.ARRAY) {
            return TypeDesc.encodeAsString(((ArrayTypeDesc)td).compTypeDesc) + "[]";
        }
        if (td.typeKind == TypeKind.TYPEVAR) {
            return "#" + ((TypeVarTypeDesc)td).identifier;
        }
        if (td.typeKind == TypeKind.DECLARED) {
            return ((ReferenceTypeDesc)td).javaType.toString();
        }
        throw new AssertionError((Object)("Unhandled type: " + (Object)((Object)td.typeKind)));
    }

    public static TypeDesc fromType(TypeMirror type) {
        SimpleTypeVisitor9<TypeDesc, Void> v = new SimpleTypeVisitor9<TypeDesc, Void>(){

            @Override
            public TypeDesc visitArray(ArrayType t, Void p) {
                return new ArrayTypeDesc(t.getComponentType().accept(this, p));
            }

            @Override
            public TypeDesc visitDeclared(DeclaredType t, Void p) {
                return new ReferenceTypeDesc(((Type.ClassType)t).tsym.flatName().toString());
            }

            @Override
            public TypeDesc visitNoType(NoType t, Void p) {
                return new PrimitiveTypeDesc(TypeKind.VOID);
            }

            @Override
            public TypeDesc visitTypeVariable(TypeVariable t, Void p) {
                return new TypeVarTypeDesc(t.toString());
            }

            @Override
            public TypeDesc visitPrimitive(PrimitiveType t, Void p) {
                return new PrimitiveTypeDesc(t.getKind());
            }

            @Override
            public TypeDesc visitError(ErrorType t, Void p) {
                return new ReferenceTypeDesc("<error type>");
            }
        };
        TypeDesc td = (TypeDesc)v.visit(type);
        if (td == null) {
            throw new AssertionError((Object)("Unhandled type mirror: " + type + " (" + type.getClass() + ")"));
        }
        return td;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.typeKind.equals((Object)((TypeDesc)obj).typeKind);
    }

    public int hashCode() {
        return this.typeKind.hashCode();
    }
}

