/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import com.sun.tools.sjavac.server.Sjavac;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CopyFile
implements Transformer {
    @Override
    public void setExtra(String e) {
    }

    @Override
    public void setExtra(Options a) {
    }

    @Override
    public boolean transform(Sjavac sjavac, Map<String, Set<URI>> pkgSrcs, Set<URI> visibleSrcs, Map<URI, Set<String>> visibleClasses, Map<String, Set<String>> oldPackageDependents, URI destRoot, Map<String, Set<URI>> packageArtifacts, Map<String, Map<String, Set<String>>> packageDependencies, Map<String, Map<String, Set<String>>> packageCpDependencies, Map<String, PubApi> packagePubapis, Map<String, PubApi> dependencyPubapis, int debugLevel, boolean incremental, int numCores, PrintStream out, PrintStream err) {
        boolean rc = true;
        for (String pkgName : pkgSrcs.keySet()) {
            String pkgNameF = Util.toFileSystemPath(pkgName);
            for (URI u : pkgSrcs.get(pkgName)) {
                File src = new File(u);
                File destDir = new File(destRoot.getPath() + File.separator + pkgNameF);
                String dest_filename = destRoot.getPath() + File.separator + pkgNameF + File.separator + src.getName();
                File dest = new File(dest_filename);
                if (!destDir.isDirectory() && !destDir.mkdirs()) {
                    Log.error("Error: The copier could not create the directory " + destDir.getPath());
                    return false;
                }
                Set<URI> as = packageArtifacts.get(pkgName);
                if (as == null) {
                    as = new HashSet<URI>();
                    packageArtifacts.put(pkgName, as);
                }
                as.add(dest.toURI());
                if (dest.exists() && dest.lastModified() > src.lastModified()) continue;
                Log.info("Copying " + pkgNameF + File.separator + src.getName());
                try {
                    FileInputStream fin = new FileInputStream(src);
                    Throwable throwable = null;
                    try {
                        FileOutputStream fout = new FileOutputStream(dest);
                        Throwable throwable2 = null;
                        try {
                            int len;
                            byte[] buf = new byte[1024];
                            while ((len = ((InputStream)fin).read(buf)) > 0) {
                                ((OutputStream)fout).write(buf, 0, len);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (fout == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ((OutputStream)fout).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ((OutputStream)fout).close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (fin == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)fin).close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        ((InputStream)fin).close();
                    }
                }
                catch (IOException e) {
                    Log.error("Could not copy the file " + src.getPath() + " to " + dest.getPath());
                    rc = false;
                }
            }
        }
        return rc;
    }
}

