/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Commented;
import com.google.errorprone.util.Comments;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;

@BugPattern(name="ParameterComment", category=BugPattern.Category.JDK, summary="Non-standard parameter comment; prefer `/*paramName=*/ arg`", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
public class ParameterComment
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (((List)symbol.getParameters()).isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ParameterComment.forEachPair(Comments.findCommentsForArguments((MethodInvocationTree)tree, (VisitorState)state).stream(), Stream.concat(symbol.getParameters().stream(), Stream.iterate(Iterables.getLast((Iterable)symbol.getParameters()), x -> x)), (commented, param) -> commented.afterComments().stream().filter(c -> ParameterComment.matchingParamComment(c, param)).findFirst().ifPresent(c -> ParameterComment.fixParamComment(fix, (Commented<ExpressionTree>)commented, param, c)));
        return fix.isEmpty() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)fix.build());
    }

    private static boolean matchingParamComment(Tokens.Comment c, Symbol.VarSymbol param) {
        String text = Comments.getTextFromComment((Tokens.Comment)c).trim();
        if (text.endsWith("=")) {
            text = text.substring(0, text.length() - "=".length()).trim();
        }
        return ((Name)param.getSimpleName()).contentEquals(text);
    }

    private static void fixParamComment(SuggestedFix.Builder fix, Commented<ExpressionTree> commented, Symbol.VarSymbol param, Tokens.Comment c) {
        fix.prefixWith(commented.tree(), String.format("/* %s= */ ", param.getSimpleName())).replace(c.getSourcePos(0), c.getSourcePos(0) + c.getText().length(), "");
    }

    static <A, B> void forEachPair(Stream<A> xs, Stream<B> bx, BiConsumer<A, B> c) {
        BiFunction<Object, Object, Void> f = (a, b) -> {
            c.accept(a, b);
            return null;
        };
        long unused = Streams.zip(xs, bx, f).count();
    }
}

