/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Printer;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public abstract class AbstractDiagnosticFormatter
implements DiagnosticFormatter<JCDiagnostic> {
    protected JavacMessages messages;
    private SimpleConfiguration config;
    protected int depth = 0;
    private List<Type> allCaptured = List.nil();
    protected Printer printer = new Printer(){

        @Override
        protected String localize(Locale locale, String string, Object ... objectArray) {
            return AbstractDiagnosticFormatter.this.localize(locale, string, objectArray);
        }

        @Override
        protected String capturedVarId(Type.CapturedType capturedType, Locale locale) {
            return "" + (AbstractDiagnosticFormatter.this.allCaptured.indexOf(capturedType) + 1);
        }

        @Override
        public String visitCapturedType(Type.CapturedType capturedType, Locale locale) {
            if (!AbstractDiagnosticFormatter.this.allCaptured.contains(capturedType)) {
                AbstractDiagnosticFormatter.this.allCaptured = AbstractDiagnosticFormatter.this.allCaptured.append(capturedType);
            }
            return super.visitCapturedType(capturedType, locale);
        }
    };

    protected AbstractDiagnosticFormatter(JavacMessages javacMessages, SimpleConfiguration simpleConfiguration) {
        this.messages = javacMessages;
        this.config = simpleConfiguration;
    }

    @Override
    public String formatKind(JCDiagnostic jCDiagnostic, Locale locale) {
        switch (jCDiagnostic.getType()) {
            case FRAGMENT: {
                return "";
            }
            case NOTE: {
                return this.localize(locale, "compiler.note.note", new Object[0]);
            }
            case WARNING: {
                return this.localize(locale, "compiler.warn.warning", new Object[0]);
            }
            case ERROR: {
                return this.localize(locale, "compiler.err.error", new Object[0]);
            }
        }
        throw new AssertionError((Object)("Unknown diagnostic type: " + (Object)((Object)jCDiagnostic.getType())));
    }

    @Override
    public String format(JCDiagnostic jCDiagnostic, Locale locale) {
        this.allCaptured = List.nil();
        return this.formatDiagnostic(jCDiagnostic, locale);
    }

    protected abstract String formatDiagnostic(JCDiagnostic var1, Locale var2);

    @Override
    public String formatPosition(JCDiagnostic jCDiagnostic, DiagnosticFormatter.PositionKind positionKind, Locale locale) {
        Assert.check(jCDiagnostic.getPosition() != -1L);
        return String.valueOf(this.getPosition(jCDiagnostic, positionKind));
    }

    private long getPosition(JCDiagnostic jCDiagnostic, DiagnosticFormatter.PositionKind positionKind) {
        switch (positionKind) {
            case START: {
                return jCDiagnostic.getIntStartPosition();
            }
            case END: {
                return jCDiagnostic.getIntEndPosition();
            }
            case LINE: {
                return jCDiagnostic.getLineNumber();
            }
            case COLUMN: {
                return jCDiagnostic.getColumnNumber();
            }
            case OFFSET: {
                return jCDiagnostic.getIntPosition();
            }
        }
        throw new AssertionError((Object)("Unknown diagnostic position: " + (Object)((Object)positionKind)));
    }

    @Override
    public String formatSource(JCDiagnostic jCDiagnostic, boolean bl, Locale locale) {
        JavaFileObject javaFileObject = jCDiagnostic.getSource();
        if (javaFileObject == null) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            return javaFileObject.getName();
        }
        if (javaFileObject instanceof BaseFileObject) {
            return ((BaseFileObject)javaFileObject).getShortName();
        }
        return BaseFileObject.getSimpleName(javaFileObject);
    }

    protected Collection<String> formatArguments(JCDiagnostic jCDiagnostic, Locale locale) {
        ListBuffer<String> listBuffer = new ListBuffer<String>();
        for (Object object : jCDiagnostic.getArgs()) {
            listBuffer.append(this.formatArgument(jCDiagnostic, object, locale));
        }
        return listBuffer.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatArgument(JCDiagnostic jCDiagnostic, Object object, Locale locale) {
        if (object instanceof JCDiagnostic) {
            String string = null;
            ++this.depth;
            try {
                string = this.formatMessage((JCDiagnostic)object, locale);
            }
            finally {
                --this.depth;
            }
            return string;
        }
        if (object instanceof JCTree.JCExpression) {
            return this.expr2String((JCTree.JCExpression)object);
        }
        if (object instanceof Iterable) {
            return this.formatIterable(jCDiagnostic, (Iterable)object, locale);
        }
        if (object instanceof Type) {
            return this.printer.visit((Type)object, locale);
        }
        if (object instanceof Symbol) {
            return this.printer.visit((Symbol)object, locale);
        }
        if (object instanceof JavaFileObject) {
            return ((JavaFileObject)object).getName();
        }
        if (object instanceof Profile) {
            return ((Profile)((Object)object)).name;
        }
        if (object instanceof Formattable) {
            return ((Formattable)object).toString(locale, this.messages);
        }
        return String.valueOf(object);
    }

    private String expr2String(JCTree.JCExpression jCExpression) {
        switch (jCExpression.getTag()) {
            case PARENS: {
                return this.expr2String(((JCTree.JCParens)jCExpression).expr);
            }
            case LAMBDA: 
            case REFERENCE: 
            case CONDEXPR: {
                return Pretty.toSimpleString(jCExpression);
            }
        }
        Assert.error("unexpected tree kind " + (Object)((Object)jCExpression.getKind()));
        return null;
    }

    protected String formatIterable(JCDiagnostic jCDiagnostic, Iterable<?> iterable, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Object obj : iterable) {
            stringBuilder.append(string);
            stringBuilder.append(this.formatArgument(jCDiagnostic, obj, locale));
            string = ",";
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> formatSubdiagnostics(JCDiagnostic jCDiagnostic, Locale locale) {
        List<String> list = List.nil();
        int n = this.config.getMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.DEPTH);
        if (n == -1 || this.depth < n) {
            ++this.depth;
            try {
                int n2 = this.config.getMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.LENGTH);
                int n3 = 0;
                for (JCDiagnostic jCDiagnostic2 : jCDiagnostic.getSubdiagnostics()) {
                    if (n2 == -1 || n3 < n2) {
                        list = list.append(this.formatSubdiagnostic(jCDiagnostic, jCDiagnostic2, locale));
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
            finally {
                --this.depth;
            }
        }
        return list;
    }

    protected String formatSubdiagnostic(JCDiagnostic jCDiagnostic, JCDiagnostic jCDiagnostic2, Locale locale) {
        return this.formatMessage(jCDiagnostic2, locale);
    }

    protected String formatSourceLine(JCDiagnostic jCDiagnostic, int n) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        DiagnosticSource diagnosticSource = jCDiagnostic.getDiagnosticSource();
        int n2 = jCDiagnostic.getIntPosition();
        if (jCDiagnostic.getIntPosition() == -1) {
            throw new AssertionError();
        }
        String string2 = string = diagnosticSource == null ? null : diagnosticSource.getLine(n2);
        if (string == null) {
            return "";
        }
        stringBuilder.append(this.indent(string, n));
        int n3 = diagnosticSource.getColumnNumber(n2, false);
        if (this.config.isCaretEnabled()) {
            stringBuilder.append("\n");
            for (int i = 0; i < n3 - 1; ++i) {
                stringBuilder.append(string.charAt(i) == '\t' ? "\t" : " ");
            }
            stringBuilder.append(this.indent("^", n));
        }
        return stringBuilder.toString();
    }

    protected String formatLintCategory(JCDiagnostic jCDiagnostic, Locale locale) {
        Lint.LintCategory lintCategory = jCDiagnostic.getLintCategory();
        if (lintCategory == null) {
            return "";
        }
        return this.localize(locale, "compiler.warn.lintOption", lintCategory.option);
    }

    protected String localize(Locale locale, String string, Object ... objectArray) {
        return this.messages.getLocalizedString(locale, string, objectArray);
    }

    @Override
    public boolean displaySource(JCDiagnostic jCDiagnostic) {
        return ((AbstractCollection)((Object)this.config.getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE) && jCDiagnostic.getType() != JCDiagnostic.DiagnosticType.FRAGMENT && jCDiagnostic.getIntPosition() != -1;
    }

    public boolean isRaw() {
        return false;
    }

    protected String indentString(int n) {
        String string = "                        ";
        if (n <= string.length()) {
            return string.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    protected String indent(String string, int n) {
        String string2 = this.indentString(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "";
        for (String string4 : string.split("\n")) {
            stringBuilder.append(string3);
            stringBuilder.append(string2 + string4);
            string3 = "\n";
        }
        return stringBuilder.toString();
    }

    @Override
    public SimpleConfiguration getConfiguration() {
        return this.config;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public static class SimpleConfiguration
    implements DiagnosticFormatter.Configuration {
        protected Map<DiagnosticFormatter.Configuration.MultilineLimit, Integer> multilineLimits = new HashMap<DiagnosticFormatter.Configuration.MultilineLimit, Integer>();
        protected EnumSet<DiagnosticFormatter.Configuration.DiagnosticPart> visibleParts;
        protected boolean caretEnabled;

        public SimpleConfiguration(Set<DiagnosticFormatter.Configuration.DiagnosticPart> set) {
            this.setVisible(set);
            this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.DEPTH, -1);
            this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.LENGTH, -1);
            this.setCaretEnabled(true);
        }

        public SimpleConfiguration(Options options, Set<DiagnosticFormatter.Configuration.DiagnosticPart> set) {
            this(set);
            String string;
            Object object;
            String string2;
            String string3 = null;
            string3 = options.get("showSource");
            if (string3 != null) {
                if (string3.equals("true")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, true);
                } else if (string3.equals("false")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, false);
                }
            }
            if ((string2 = options.get("diags")) != null) {
                object = Arrays.asList(string2.split(","));
                if (object.contains("short")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, false);
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, false);
                }
                if (object.contains("source")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, true);
                }
                if (object.contains("-source")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, false);
                }
            }
            object = null;
            object = options.get("multilinePolicy");
            if (object != null) {
                if (((String)object).equals("disabled")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, false);
                } else if (((String)object).startsWith("limit:")) {
                    string = ((String)object).substring("limit:".length());
                    String[] stringArray = string.split(":");
                    try {
                        switch (stringArray.length) {
                            case 2: {
                                if (!stringArray[1].equals("*")) {
                                    this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.DEPTH, Integer.parseInt(stringArray[1]));
                                }
                            }
                            case 1: {
                                if (stringArray[0].equals("*")) break;
                                this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.LENGTH, Integer.parseInt(stringArray[0]));
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.DEPTH, -1);
                        this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.LENGTH, -1);
                    }
                }
            }
            string = null;
            string = options.get("showCaret");
            if (string != null && string.equals("false")) {
                this.setCaretEnabled(false);
            } else {
                this.setCaretEnabled(true);
            }
        }

        @Override
        public int getMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit multilineLimit) {
            return this.multilineLimits.get((Object)multilineLimit);
        }

        public EnumSet<DiagnosticFormatter.Configuration.DiagnosticPart> getVisible() {
            return EnumSet.copyOf(this.visibleParts);
        }

        @Override
        public void setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit multilineLimit, int n) {
            this.multilineLimits.put(multilineLimit, n < -1 ? -1 : n);
        }

        @Override
        public void setVisible(Set<DiagnosticFormatter.Configuration.DiagnosticPart> set) {
            this.visibleParts = EnumSet.copyOf(set);
        }

        public void setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart diagnosticPart, boolean bl) {
            if (bl) {
                this.visibleParts.add(diagnosticPart);
            } else {
                this.visibleParts.remove((Object)diagnosticPart);
            }
        }

        public void setCaretEnabled(boolean bl) {
            this.caretEnabled = bl;
        }

        public boolean isCaretEnabled() {
            return this.caretEnabled;
        }
    }
}

