/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(name="ShouldHaveEvenArgs", summary="This method must be called with an even number of arguments.", category=BugPattern.Category.TRUTH, severity=BugPattern.SeverityLevel.ERROR)
public class ShouldHaveEvenArgs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.common.truth.MapSubject", "com.google.common.truth.MapSubject.UsingCorrespondence"}).named("containsExactly");

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Type lastArgType;
        if (!MATCHER.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (methodInvocationTree.getArguments().size() % 2 == 0) {
            return Description.NO_MATCH;
        }
        JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)methodInvocationTree;
        List arguments = methodInvocation.getArguments();
        Type typeVargs = methodInvocation.varargsElement;
        if (typeVargs == null) {
            return Description.NO_MATCH;
        }
        Type typeVarargsArr = state.arrayTypeForType(typeVargs);
        if (typeVarargsArr.equals(lastArgType = ASTHelpers.getType((Tree)((Tree)Iterables.getLast((Iterable)arguments))))) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodInvocationTree);
    }
}

