/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;

public abstract class InvocationBuilder {
    public static final long DEFAULT_CALL_TIMEOUT = -1L;
    public static final int DEFAULT_REPLICA_INDEX = 0;
    public static final int DEFAULT_TRY_COUNT = 250;
    public static final long DEFAULT_TRY_PAUSE_MILLIS = 500L;
    public static final boolean DEFAULT_DESERIALIZE_RESULT = true;
    protected final NodeEngineImpl nodeEngine;
    protected final String serviceName;
    protected final Operation op;
    protected final int partitionId;
    protected final Address target;
    protected Callback<Object> callback;
    protected ExecutionCallback<Object> executionCallback;
    protected long callTimeout = -1L;
    protected int replicaIndex;
    protected int tryCount = 250;
    protected long tryPauseMillis = 500L;
    protected boolean resultDeserialized = true;

    public InvocationBuilder(NodeEngineImpl nodeEngine, String serviceName, Operation op, int partitionId, Address target) {
        this.nodeEngine = nodeEngine;
        this.serviceName = serviceName;
        this.op = op;
        this.partitionId = partitionId;
        this.target = target;
    }

    public InvocationBuilder setReplicaIndex(int replicaIndex) {
        if (replicaIndex < 0 || replicaIndex >= 7) {
            throw new IllegalArgumentException("Replica index is out of range [0-6]");
        }
        this.replicaIndex = replicaIndex;
        return this;
    }

    public boolean isResultDeserialized() {
        return this.resultDeserialized;
    }

    public InvocationBuilder setResultDeserialized(boolean resultDeserialized) {
        this.resultDeserialized = resultDeserialized;
        return this;
    }

    public InvocationBuilder setTryCount(int tryCount) {
        this.tryCount = tryCount;
        return this;
    }

    public InvocationBuilder setTryPauseMillis(long tryPauseMillis) {
        this.tryPauseMillis = tryPauseMillis;
        return this;
    }

    public InvocationBuilder setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Operation getOp() {
        return this.op;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public long getTryPauseMillis() {
        return this.tryPauseMillis;
    }

    public Address getTarget() {
        return this.target;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    @Deprecated
    public Callback getCallback() {
        return this.callback;
    }

    @Deprecated
    public InvocationBuilder setCallback(Callback<Object> callback) {
        if (this.executionCallback != null) {
            throw new IllegalStateException("Can't set the callback if executionCallback already is set");
        }
        this.callback = callback;
        return this;
    }

    public ExecutionCallback<Object> getExecutionCallback() {
        return this.executionCallback;
    }

    public InvocationBuilder setExecutionCallback(ExecutionCallback<Object> executionCallback) {
        if (this.callback != null) {
            throw new IllegalStateException("Can't set the executionCallback if callback already is set");
        }
        this.executionCallback = executionCallback;
        return this;
    }

    protected ExecutionCallback getTargetExecutionCallback() {
        ExecutionCallback<Object> targetCallback = this.executionCallback;
        if (this.callback != null) {
            targetCallback = new ExecutorCallbackAdapter<Object>(this.callback);
        }
        return targetCallback;
    }

    public abstract <E> InternalCompletableFuture<E> invoke();

    static final class ExecutorCallbackAdapter<E>
    implements ExecutionCallback<E> {
        private final Callback callback;

        private ExecutorCallbackAdapter(Callback callback) {
            this.callback = callback;
        }

        @Override
        public void onResponse(E response) {
            this.callback.notify(response);
        }

        @Override
        public void onFailure(Throwable t) {
            this.callback.notify(t);
        }
    }
}

