/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import javax.cache.processor.EntryProcessor;

public class CacheEntryProcessorRequest
extends AbstractCacheRequest {
    private Data key;
    private EntryProcessor entryProcessor;
    private Object[] arguments;
    private int completionId;

    public CacheEntryProcessorRequest() {
    }

    public CacheEntryProcessorRequest(String name, Data key, EntryProcessor entryProcessor, InMemoryFormat inMemoryFormat, Object ... arguments) {
        super(name, inMemoryFormat);
        this.key = key;
        this.entryProcessor = entryProcessor;
        this.arguments = arguments;
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        CacheOperationProvider operationProvider = this.getOperationProvider();
        return operationProvider.createEntryProcessorOperation(this.key, this.completionId, this.entryProcessor, this.arguments);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("c", this.completionId);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeObject(this.entryProcessor);
        out.writeBoolean(this.arguments != null);
        if (this.arguments != null) {
            out.writeInt(this.arguments.length);
            for (Object arg : this.arguments) {
                out.writeObject(arg);
            }
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.completionId = reader.readInt("c");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.entryProcessor = (EntryProcessor)in.readObject();
        boolean hasArguments = in.readBoolean();
        if (hasArguments) {
            int size = in.readInt();
            this.arguments = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.arguments[i] = in.readObject();
            }
        }
    }

    @Override
    public void setCompletionId(Integer completionId) {
        this.completionId = completionId != null ? completionId : -1;
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(this.name, "read", "put", "remove");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, null, this.arguments};
    }

    @Override
    public String getMethodName() {
        return "invoke";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

