/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class TransferInput<A extends AbstractValue<A>, S extends Store<S>> {
    protected Node node;
    protected final S store;
    protected final S thenStore;
    protected final S elseStore;
    protected final Analysis<A, S, ?> analysis;

    public TransferInput(Node n, Analysis<A, S, ?> analysis, TransferResult<A, S> to) {
        this.node = n;
        this.analysis = analysis;
        if (to.containsTwoStores()) {
            this.thenStore = to.getThenStore();
            this.elseStore = to.getElseStore();
            this.store = null;
        } else {
            this.store = to.getRegularStore();
            this.elseStore = null;
            this.thenStore = null;
        }
    }

    public TransferInput(Node n, Analysis<A, S, ?> analysis, S s) {
        this.node = n;
        this.analysis = analysis;
        this.store = s;
        this.elseStore = null;
        this.thenStore = null;
    }

    public TransferInput(Node n, Analysis<A, S, ?> analysis, S s1, S s2) {
        this.node = n;
        this.analysis = analysis;
        this.thenStore = s1;
        this.elseStore = s2;
        this.store = null;
    }

    protected TransferInput(TransferInput<A, S> from) {
        this.node = from.node;
        this.analysis = from.analysis;
        if (from.store == null) {
            this.thenStore = from.thenStore.copy();
            this.elseStore = from.elseStore.copy();
            this.store = null;
        } else {
            this.store = from.store.copy();
            this.elseStore = null;
            this.thenStore = null;
        }
    }

    public Node getNode() {
        return this.node;
    }

    public A getValueOfSubNode(Node n) {
        return this.analysis.getValue(n);
    }

    public S getRegularStore() {
        if (this.store == null) {
            return this.thenStore.leastUpperBound(this.elseStore);
        }
        return this.store;
    }

    public S getThenStore() {
        if (this.store == null) {
            return this.thenStore;
        }
        return this.store;
    }

    public S getElseStore() {
        if (this.store == null) {
            return this.elseStore;
        }
        return this.store.copy();
    }

    public boolean containsTwoStores() {
        return this.thenStore != null && this.elseStore != null;
    }

    public TransferInput<A, S> copy() {
        return new TransferInput<A, S>(this);
    }

    public TransferInput<A, S> leastUpperBound(TransferInput<A, S> other) {
        if (this.store == null) {
            S newThenStore = this.thenStore.leastUpperBound(other.getThenStore());
            S newElseStore = this.elseStore.leastUpperBound(other.getElseStore());
            return new TransferInput<A, S>(this.node, this.analysis, newThenStore, newElseStore);
        }
        if (other.store == null) {
            return other.leastUpperBound(this);
        }
        return new TransferInput<A, S>(this.node, this.analysis, this.store.leastUpperBound(other.getRegularStore()));
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof TransferInput) {
            TransferInput other = (TransferInput)o;
            if (this.containsTwoStores()) {
                if (other.containsTwoStores()) {
                    return this.getThenStore().equals(other.getThenStore()) && this.getElseStore().equals(other.getElseStore());
                }
            } else if (!other.containsTwoStores()) {
                return this.getRegularStore().equals(other.getRegularStore());
            }
        }
        return false;
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.analysis, this.node, this.store, this.thenStore, this.elseStore);
    }

    public String toString() {
        if (this.store == null) {
            return "[then=" + this.thenStore + ", else=" + this.elseStore + "]";
        }
        return "[" + this.store + "]";
    }

    public boolean hasDOToutput() {
        return true;
    }

    public String toDOToutput() {
        if (this.store == null) {
            if (this.thenStore.hasDOToutput()) {
                return "[then=" + this.thenStore.toDOToutput() + ", else=" + this.elseStore.toDOToutput() + "]";
            }
            return "[then=" + this.thenStore + ", else=" + this.elseStore + "]";
        }
        if (this.store.hasDOToutput()) {
            return "[" + this.store.toDOToutput() + "]";
        }
        return "[" + this.store + "]";
    }
}

