/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Lint {
    protected static final Context.Key<Lint> lintKey = new Context.Key();
    private final AugmentVisitor augmentor;
    private final EnumSet<LintCategory> values;
    private final EnumSet<LintCategory> suppressedValues;
    private static final Map<String, LintCategory> map = new ConcurrentHashMap<String, LintCategory>(20);

    public static Lint instance(Context context) {
        Lint lint = context.get(lintKey);
        if (lint == null) {
            lint = new Lint(context);
        }
        return lint;
    }

    public Lint augment(Attribute.Compound compound) {
        return this.augmentor.augment(this, compound);
    }

    public Lint augment(Symbol symbol) {
        Lint lint = this.augmentor.augment(this, symbol.getDeclarationAttributes());
        if (symbol.isDeprecated()) {
            if (lint == this) {
                lint = new Lint(this);
            }
            lint.values.remove((Object)LintCategory.DEPRECATION);
            lint.suppressedValues.add(LintCategory.DEPRECATION);
        }
        return lint;
    }

    public Lint suppress(LintCategory ... lintCategoryArray) {
        Lint lint = new Lint(this);
        lint.values.removeAll(Arrays.asList(lintCategoryArray));
        lint.suppressedValues.addAll(Arrays.asList(lintCategoryArray));
        return lint;
    }

    protected Lint(Context context) {
        Options options = Options.instance(context);
        if (options.isSet(Option.XLINT) || options.isSet(Option.XLINT_CUSTOM, "all")) {
            this.values = EnumSet.allOf(LintCategory.class);
        } else if (options.isSet(Option.XLINT_CUSTOM, "none")) {
            this.values = EnumSet.noneOf(LintCategory.class);
        } else {
            this.values = EnumSet.noneOf(LintCategory.class);
            Source object = Source.instance(context);
            if (object.compareTo(Source.JDK1_9) >= 0) {
                this.values.add(LintCategory.DEP_ANN);
            }
            this.values.add(LintCategory.OPENS);
            this.values.add(LintCategory.MODULE);
            this.values.add(LintCategory.REMOVAL);
        }
        for (LintCategory lintCategory : LintCategory.values()) {
            if (options.isSet(Option.XLINT_CUSTOM, lintCategory.option)) {
                this.values.add(lintCategory);
                continue;
            }
            if (!options.isSet(Option.XLINT_CUSTOM, "-" + lintCategory.option)) continue;
            this.values.remove((Object)lintCategory);
        }
        this.suppressedValues = EnumSet.noneOf(LintCategory.class);
        context.put(lintKey, this);
        this.augmentor = new AugmentVisitor(context);
    }

    protected Lint(Lint lint) {
        this.augmentor = lint.augmentor;
        this.values = lint.values.clone();
        this.suppressedValues = lint.suppressedValues.clone();
    }

    public String toString() {
        return "Lint:[values" + this.values + " suppressedValues" + this.suppressedValues + "]";
    }

    public boolean isEnabled(LintCategory lintCategory) {
        return this.values.contains((Object)lintCategory);
    }

    public boolean isSuppressed(LintCategory lintCategory) {
        return this.suppressedValues.contains((Object)lintCategory);
    }

    protected static class AugmentVisitor
    implements Attribute.Visitor {
        private final Context context;
        private Symtab syms;
        private Lint parent;
        private Lint lint;

        AugmentVisitor(Context context) {
            this.context = context;
        }

        Lint augment(Lint lint, Attribute.Compound compound) {
            this.initSyms();
            this.parent = lint;
            this.lint = null;
            compound.accept(this);
            return this.lint == null ? lint : this.lint;
        }

        Lint augment(Lint lint, List<Attribute.Compound> list) {
            this.initSyms();
            this.parent = lint;
            this.lint = null;
            for (Attribute.Compound compound : list) {
                compound.accept(this);
            }
            return this.lint == null ? lint : this.lint;
        }

        private void initSyms() {
            if (this.syms == null) {
                this.syms = Symtab.instance(this.context);
            }
        }

        private void suppress(LintCategory lintCategory) {
            if (this.lint == null) {
                this.lint = new Lint(this.parent);
            }
            this.lint.suppressedValues.add(lintCategory);
            this.lint.values.remove((Object)lintCategory);
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            LintCategory lintCategory;
            if (constant.type.tsym == this.syms.stringType.tsym && (lintCategory = LintCategory.get((String)constant.value)) != null) {
                this.suppress(lintCategory);
            }
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            if (compound.type.tsym == this.syms.suppressWarningsType.tsym) {
                List<Pair<Symbol.MethodSymbol, Attribute>> list = compound.values;
                while (list.nonEmpty()) {
                    Pair pair = (Pair)list.head;
                    if (((Symbol.MethodSymbol)pair.fst).name.toString().equals("value")) {
                        ((Attribute)pair.snd).accept(this);
                    }
                    list = list.tail;
                }
            }
        }

        @Override
        public void visitArray(Attribute.Array array) {
            for (Attribute attribute : array.values) {
                attribute.accept(this);
            }
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
        }

        @Override
        public void visitError(Attribute.Error error) {
        }
    }

    public static enum LintCategory {
        AUXILIARYCLASS("auxiliaryclass"),
        CAST("cast"),
        CLASSFILE("classfile"),
        DEPRECATION("deprecation"),
        DEP_ANN("dep-ann"),
        DIVZERO("divzero"),
        EMPTY("empty"),
        EXPORTS("exports"),
        FALLTHROUGH("fallthrough"),
        FINALLY("finally"),
        MODULE("module"),
        OPENS("opens"),
        OPTIONS("options"),
        OVERLOADS("overloads"),
        OVERRIDES("overrides"),
        PATH("path"),
        PROCESSING("processing"),
        RAW("rawtypes"),
        REMOVAL("removal"),
        SERIAL("serial"),
        STATIC("static"),
        TRY("try"),
        UNCHECKED("unchecked"),
        VARARGS("varargs");

        public final String option;
        public final boolean hidden;

        private LintCategory(String string2) {
            this(string2, false);
        }

        private LintCategory(String string2, boolean bl) {
            this.option = string2;
            this.hidden = bl;
            map.put(string2, this);
        }

        static LintCategory get(String string) {
            return (LintCategory)((Object)map.get(string));
        }
    }
}

