/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReferenceEquality;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="OptionalEquality", summary="Comparison using reference equality instead of value equality", explanation="Optionals should be compared for value equality using `.equals()`, and not for reference equality using `==` and `!=`.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR)
public class OptionalEquality
extends AbstractReferenceEquality {
    private static final ImmutableSet<String> OPTIONAL_CLASSES = ImmutableSet.of((Object)Optional.class.getName(), (Object)"java.util.Optional");

    @Override
    protected boolean matchArgument(ExpressionTree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        for (String className : OPTIONAL_CLASSES) {
            if (!ASTHelpers.isSameType((Type)type, (Type)state.getTypeFromString(className), (VisitorState)state)) continue;
            return true;
        }
        return false;
    }
}

