/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;

@BugPattern(name="NullablePrimitive", summary="@Nullable should not be used for primitive types since they cannot be null", explanation="Primitives can never be null.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class NullablePrimitive
extends BugChecker
implements BugChecker.AnnotatedTypeTreeMatcher,
BugChecker.VariableTreeMatcher,
BugChecker.MethodTreeMatcher {
    public Description matchAnnotatedType(AnnotatedTypeTree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        return this.check(type, tree.getAnnotations());
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        return this.check(sym.getReturnType(), tree.getModifiers().getAnnotations());
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        return this.check(sym.type, tree.getModifiers().getAnnotations());
    }

    private Description check(Type type, List<? extends AnnotationTree> annotations) {
        if (type == null) {
            return Description.NO_MATCH;
        }
        if (!type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(annotations, (String)"Nullable");
        if (annotation == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(annotation, (Fix)SuggestedFix.delete((Tree)annotation));
    }
}

