/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;

@BugPattern(name="JUnitAmbiguousTestClass", summary="Test class inherits from JUnit 3's TestCase but has JUnit 4 @Test annotations.", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.WARNING)
public class JUnitAmbiguousTestClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{JUnitMatchers.isTestCaseDescendant, JUnitMatchers.hasJUnit4TestCases});

    public Description matchClass(ClassTree classTree, VisitorState state) {
        return MATCHER.matches((Tree)classTree, state) ? this.describeMatch(classTree) : Description.NO_MATCH;
    }
}

