/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractArgumentParameterChecker;
import com.google.errorprone.bugpatterns.ArgumentParameterSimilarityMetrics;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.function.Function;

@BugPattern(name="ArgumentParameterMismatch", summary="A different potential argument is more similar to the name of the parameter than the existing argument; this may be an error", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class ArgumentParameterMismatch
extends AbstractArgumentParameterChecker {
    private static final ImmutableSet<Tree.Kind> VALID_KINDS = ImmutableSet.of((Object)((Object)Tree.Kind.IDENTIFIER));
    private static final Function<VisitorState, ImmutableSet<AbstractArgumentParameterChecker.PotentialReplacement>> POTENTIAL_REPLACEMENTS_FUNCTION = state -> (ImmutableSet)FindIdentifiers.findAllIdents((VisitorState)state).stream().map(ArgumentParameterMismatch::potentialReplacement).collect(ImmutableSet.toImmutableSet());

    public ArgumentParameterMismatch() {
        this((ImmutableSet<String>)ImmutableSet.of((Object)"index", (Object)"item", (Object)"key", (Object)"value"), 0.667);
    }

    public ArgumentParameterMismatch(ImmutableSet<String> ignoreParams, double beta) {
        super(POTENTIAL_REPLACEMENTS_FUNCTION, new AbstractArgumentParameterChecker.ParameterPredicate(ignoreParams, 4), beta, ArgumentParameterSimilarityMetrics::computeNormalizedTermIntersection, VALID_KINDS);
    }

    private static AbstractArgumentParameterChecker.PotentialReplacement potentialReplacement(Symbol.VarSymbol sym) {
        return AbstractArgumentParameterChecker.PotentialReplacement.create(((Name)sym.getSimpleName()).toString(), ((Name)sym.getSimpleName()).toString(), sym);
    }
}

