/*
 * Decompiled with CFR 0.152.
 */
package dagger.shaded.auto.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import dagger.shaded.auto.common.MoreTypes;
import dagger.shaded.auto.common.Visibility;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;

@Beta
public final class MoreElements {
    private static final ElementVisitor<PackageElement, Void> PACKAGE_ELEMENT_VISITOR = new SimpleElementVisitor6<PackageElement, Void>(){

        @Override
        protected PackageElement defaultAction(Element e, Void p) {
            throw new IllegalArgumentException();
        }

        @Override
        public PackageElement visitPackage(PackageElement e, Void p) {
            return e;
        }
    };
    private static final ElementVisitor<TypeElement, Void> TYPE_ELEMENT_VISITOR = new SimpleElementVisitor6<TypeElement, Void>(){

        @Override
        protected TypeElement defaultAction(Element e, Void p) {
            throw new IllegalArgumentException();
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    };
    private static final ElementVisitor<VariableElement, Void> VARIABLE_ELEMENT_VISITOR = new SimpleElementVisitor6<VariableElement, Void>(){

        @Override
        protected VariableElement defaultAction(Element e, Void p) {
            throw new IllegalArgumentException();
        }

        @Override
        public VariableElement visitVariable(VariableElement e, Void p) {
            return e;
        }
    };
    private static final ElementVisitor<ExecutableElement, Void> EXECUTABLE_ELEMENT_VISITOR = new SimpleElementVisitor6<ExecutableElement, Void>(){

        @Override
        protected ExecutableElement defaultAction(Element e, Void p) {
            throw new IllegalArgumentException();
        }

        @Override
        public ExecutableElement visitExecutable(ExecutableElement e, Void p) {
            return e;
        }
    };

    public static PackageElement getPackage(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public static PackageElement asPackage(Element element) {
        return element.accept(PACKAGE_ELEMENT_VISITOR, null);
    }

    public static boolean isType(Element element) {
        return element.getKind().isClass() || element.getKind().isInterface();
    }

    public static TypeElement asType(Element element) {
        return element.accept(TYPE_ELEMENT_VISITOR, null);
    }

    public static VariableElement asVariable(Element element) {
        return element.accept(VARIABLE_ELEMENT_VISITOR, null);
    }

    public static ExecutableElement asExecutable(Element element) {
        return element.accept(EXECUTABLE_ELEMENT_VISITOR, null);
    }

    public static boolean isAnnotationPresent(Element element, Class<? extends Annotation> annotationClass) {
        return MoreElements.getAnnotationMirror(element, annotationClass).isPresent();
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = MoreElements.asType(annotationMirror.getAnnotationType().asElement());
            if (!annotationTypeElement.getQualifiedName().contentEquals(annotationClassName)) continue;
            return Optional.of((Object)annotationMirror);
        }
        return Optional.absent();
    }

    public static Predicate<Element> hasModifiers(Modifier ... modifiers) {
        return MoreElements.hasModifiers((Set<Modifier>)ImmutableSet.copyOf((Object[])modifiers));
    }

    public static Predicate<Element> hasModifiers(final Set<Modifier> modifiers) {
        return new Predicate<Element>(){

            public boolean apply(Element input) {
                return input.getModifiers().containsAll(modifiers);
            }
        };
    }

    public static ImmutableSet<ExecutableElement> getLocalAndInheritedMethods(TypeElement type, Elements elementUtils) {
        LinkedHashMultimap methodMap = LinkedHashMultimap.create();
        MoreElements.getLocalAndInheritedMethods(MoreElements.getPackage(type), type, (SetMultimap<String, ExecutableElement>)methodMap);
        LinkedHashSet<ExecutableElement> overridden = new LinkedHashSet<ExecutableElement>();
        for (String methodName : methodMap.keySet()) {
            ImmutableList methodList = ImmutableList.copyOf((Collection)methodMap.get((Object)methodName));
            for (int i = 0; i < methodList.size(); ++i) {
                ExecutableElement methodI = (ExecutableElement)methodList.get(i);
                for (int j = i + 1; j < methodList.size(); ++j) {
                    ExecutableElement methodJ = (ExecutableElement)methodList.get(j);
                    if (!elementUtils.overrides(methodJ, methodI, type)) continue;
                    overridden.add(methodI);
                }
            }
        }
        LinkedHashSet methods = new LinkedHashSet(methodMap.values());
        methods.removeAll(overridden);
        return ImmutableSet.copyOf(methods);
    }

    private static void getLocalAndInheritedMethods(PackageElement pkg, TypeElement type, SetMultimap<String, ExecutableElement> methods) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            MoreElements.getLocalAndInheritedMethods(pkg, MoreTypes.asTypeElement(typeMirror), methods);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            MoreElements.getLocalAndInheritedMethods(pkg, MoreTypes.asTypeElement(type.getSuperclass()), methods);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (executableElement.getModifiers().contains((Object)Modifier.STATIC) || !MoreElements.methodVisibleFromPackage(executableElement, pkg)) continue;
            methods.put((Object)executableElement.getSimpleName().toString(), (Object)executableElement);
        }
    }

    private static boolean methodVisibleFromPackage(ExecutableElement method, PackageElement pkg) {
        Visibility visibility = Visibility.ofElement(method);
        switch (visibility) {
            case PRIVATE: {
                return false;
            }
            case DEFAULT: {
                return MoreElements.getPackage(method).equals(pkg);
            }
        }
        return true;
    }

    private MoreElements() {
    }
}

