/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AbstractComponentWriter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.TypeSpecs;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

final class SubcomponentWriter
extends AbstractComponentWriter {
    private AbstractComponentWriter parent;
    private ExecutableElement subcomponentFactoryMethod;

    public SubcomponentWriter(AbstractComponentWriter parent, ExecutableElement subcomponentFactoryMethod, BindingGraph subgraph) {
        super(parent.types, parent.elements, parent.keyFactory, parent.compilerOptions, SubcomponentWriter.subcomponentName(parent, subgraph), subgraph, parent.subcomponentNames);
        this.parent = parent;
        this.subcomponentFactoryMethod = subcomponentFactoryMethod;
    }

    private static ClassName subcomponentName(AbstractComponentWriter parent, BindingGraph subgraph) {
        return parent.name.nestedClass(String.valueOf((String)parent.subcomponentNames.get((Object)subgraph.componentDescriptor())).concat("Impl"));
    }

    @Override
    protected AbstractComponentWriter.InitializationState getInitializationState(BindingKey bindingKey) {
        AbstractComponentWriter.InitializationState initializationState = super.getInitializationState(bindingKey);
        return initializationState.equals((Object)AbstractComponentWriter.InitializationState.UNINITIALIZED) ? this.parent.getInitializationState(bindingKey) : initializationState;
    }

    @Override
    protected Optional<CodeBlock> getOrCreateComponentContributionFieldExpression(TypeElement contributionType) {
        return super.getOrCreateComponentContributionFieldExpression(contributionType).or(this.parent.getOrCreateComponentContributionFieldExpression(contributionType));
    }

    @Override
    protected MemberSelect getMemberSelect(BindingKey key) {
        MemberSelect memberSelect = super.getMemberSelect(key);
        return memberSelect == null ? this.parent.getMemberSelect(key) : memberSelect;
    }

    private ExecutableType resolvedSubcomponentFactoryMethod() {
        return MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(this.parent.componentDefinitionType().asType()), this.subcomponentFactoryMethod));
    }

    @Override
    protected TypeSpec.Builder createComponentClass() {
        TypeSpec.Builder subcomponent = TypeSpec.classBuilder(this.name).addModifiers(Modifier.PRIVATE, Modifier.FINAL);
        TypeSpecs.addSupertype(subcomponent, MoreTypes.asTypeElement(this.graph.componentDescriptor().builderSpec().isPresent() ? ((ComponentDescriptor.BuilderSpec)this.graph.componentDescriptor().builderSpec().get()).componentType() : this.resolvedSubcomponentFactoryMethod().getReturnType()));
        return subcomponent;
    }

    @Override
    protected void addBuilder() {
        if (this.graph.componentDescriptor().builderSpec().isPresent()) {
            super.addBuilder();
        }
    }

    @Override
    protected ClassName builderName() {
        return this.name.peerClass(String.valueOf((String)this.subcomponentNames.get((Object)this.graph.componentDescriptor())).concat("Builder"));
    }

    @Override
    protected TypeSpec.Builder createBuilder(String builderSimpleName) {
        Verify.verify((boolean)this.graph.componentDescriptor().builderSpec().isPresent());
        return TypeSpec.classBuilder(builderSimpleName);
    }

    @Override
    protected void addBuilderClass(TypeSpec builder) {
        this.parent.component.addType(builder);
    }

    @Override
    protected void addFactoryMethods() {
        MethodSpec.Builder componentMethod = MethodSpec.methodBuilder(this.subcomponentFactoryMethod.getSimpleName().toString()).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class);
        if (this.graph.componentDescriptor().builderSpec().isPresent()) {
            ComponentDescriptor.BuilderSpec spec = (ComponentDescriptor.BuilderSpec)this.graph.componentDescriptor().builderSpec().get();
            componentMethod.returns(ClassName.get(spec.builderDefinitionType())).addStatement("return new $T()", this.builderName.get());
        } else {
            ExecutableType resolvedMethod = this.resolvedSubcomponentFactoryMethod();
            componentMethod.returns(ClassName.get(resolvedMethod.getReturnType()));
            this.writeSubcomponentWithoutBuilder(componentMethod, resolvedMethod);
        }
        this.parent.component.addMethod(componentMethod.build());
    }

    private void writeSubcomponentWithoutBuilder(MethodSpec.Builder componentMethod, ExecutableType resolvedMethod) {
        ImmutableList.Builder subcomponentConstructorParameters = ImmutableList.builder();
        List<? extends VariableElement> params = this.subcomponentFactoryMethod.getParameters();
        List<? extends TypeMirror> paramTypes = resolvedMethod.getParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            VariableElement moduleVariable = params.get(i);
            TypeElement moduleTypeElement = MoreTypes.asTypeElement(paramTypes.get(i));
            TypeName moduleType = TypeName.get(paramTypes.get(i));
            componentMethod.addParameter(moduleType, moduleVariable.getSimpleName().toString(), new Modifier[0]);
            if (this.componentContributionFields.containsKey(moduleTypeElement)) continue;
            String preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleTypeElement.getSimpleName().toString());
            FieldSpec contributionField = this.componentField(ClassName.get(moduleTypeElement), preferredModuleName).addModifiers(Modifier.PRIVATE, Modifier.FINAL).build();
            this.component.addField(contributionField);
            String actualModuleName = contributionField.name;
            this.constructor.addParameter(moduleType, actualModuleName, new Modifier[0]).addStatement("this.$1L = $2T.checkNotNull($1L)", actualModuleName, Preconditions.class);
            MemberSelect moduleSelect = MemberSelect.localField(this.name, actualModuleName);
            this.componentContributionFields.put(moduleTypeElement, moduleSelect);
            subcomponentConstructorParameters.add((Object)CodeBlock.of("$L", moduleVariable.getSimpleName()));
        }
        Sets.SetView uninitializedModules = Sets.difference(this.graph.componentRequirements(), this.componentContributionFields.keySet());
        for (TypeElement moduleType : uninitializedModules) {
            String preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleType.getSimpleName().toString());
            FieldSpec contributionField = this.componentField(ClassName.get(moduleType), preferredModuleName).addModifiers(Modifier.PRIVATE, Modifier.FINAL).build();
            this.component.addField(contributionField);
            String actualModuleName = contributionField.name;
            this.constructor.addStatement("this.$L = new $T()", actualModuleName, ClassName.get(moduleType));
            MemberSelect moduleSelect = MemberSelect.localField(this.name, actualModuleName);
            this.componentContributionFields.put(moduleType, moduleSelect);
        }
        componentMethod.addStatement("return new $T($L)", this.name, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)subcomponentConstructorParameters.build()));
    }
}

