/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.MapKey;
import dagger.internal.codegen.MapKeyGenerator;
import dagger.internal.codegen.MapKeyValidator;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

public class MapKeyProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final Types types;
    private final MapKeyValidator mapKeyValidator;
    private final MapKeyGenerator mapKeyGenerator;

    MapKeyProcessingStep(Messager messager, Types types, MapKeyValidator mapKeyValidator, MapKeyGenerator mapKeyGenerator) {
        this.messager = messager;
        this.types = types;
        this.mapKeyValidator = mapKeyValidator;
        this.mapKeyGenerator = mapKeyGenerator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(MapKey.class);
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (Element element : elementsByAnnotation.get(MapKey.class)) {
            ValidationReport<Element> mapKeyReport = this.mapKeyValidator.validate(element);
            mapKeyReport.printMessagesTo(this.messager);
            if (!mapKeyReport.isClean()) continue;
            MapKey mapkey = element.getAnnotation(MapKey.class);
            if (mapkey.unwrapValue()) {
                DeclaredType keyType = MapKeys.getUnwrappedMapKeyType(MoreTypes.asDeclared(element.asType()), this.types);
                if (keyType.asElement().getKind() != ElementKind.ANNOTATION_TYPE) continue;
                this.writeCreatorClass(MapKeyGenerator.MapKeyCreatorSpecification.unwrappedMapKeyWithAnnotationValue(MoreElements.asType(element), MoreTypes.asTypeElement(keyType)));
                continue;
            }
            this.writeCreatorClass(MapKeyGenerator.MapKeyCreatorSpecification.wrappedMapKey(MoreElements.asType(element)));
        }
        return ImmutableSet.of();
    }

    private void writeCreatorClass(MapKeyGenerator.MapKeyCreatorSpecification mapKeyCreatorType) {
        try {
            this.mapKeyGenerator.generate(mapKeyCreatorType);
        }
        catch (SourceFileGenerationException e) {
            e.printMessageTo(this.messager);
        }
    }
}

