/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import dagger.internal.codegen.DependencyRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DependencyVariableNamer
implements Function<DependencyRequest, String> {
    private static final Pattern LAZY_PROVIDER_PATTERN = Pattern.compile("lazy(\\w+)Provider");

    DependencyVariableNamer() {
    }

    public String apply(DependencyRequest dependency) {
        if (dependency.overriddenVariableName().isPresent()) {
            return (String)dependency.overriddenVariableName().get();
        }
        String variableName = dependency.requestElement().getSimpleName().toString();
        if (Ascii.isUpperCase((char)variableName.charAt(0))) {
            variableName = this.toLowerCamel(variableName);
        }
        switch (dependency.kind()) {
            case INSTANCE: {
                return variableName;
            }
            case LAZY: {
                return variableName.startsWith("lazy") && !variableName.equals("lazy") ? this.toLowerCamel(variableName.substring(4)) : variableName;
            }
            case PROVIDER_OF_LAZY: {
                Matcher matcher = LAZY_PROVIDER_PATTERN.matcher(variableName);
                if (matcher.matches()) {
                    return this.toLowerCamel(matcher.group(1));
                }
            }
            case PROVIDER: {
                return variableName.endsWith("Provider") && !variableName.equals("Provider") ? variableName.substring(0, variableName.length() - 8) : variableName;
            }
            case MEMBERS_INJECTOR: {
                return variableName.endsWith("MembersInjector") && !variableName.equals("MembersInjector") ? variableName.substring(0, variableName.length() - 15) : variableName;
            }
            case PRODUCED: {
                return variableName.startsWith("produced") && !variableName.equals("produced") ? this.toLowerCamel(variableName.substring(8)) : variableName;
            }
            case PRODUCER: {
                return variableName.endsWith("Producer") && !variableName.equals("Producer") ? variableName.substring(0, variableName.length() - 8) : variableName;
            }
        }
        throw new AssertionError();
    }

    private String toLowerCamel(String name) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name);
    }
}

