/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Longs;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveLongArraySubject
extends AbstractArraySubject<PrimitiveLongArraySubject, long[]> {
    PrimitiveLongArraySubject(FailureStrategy failureStrategy, @Nullable long[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "long";
    }

    @Override
    protected List<Long> listRepresentation() {
        return Longs.asList((long[])((long[])this.actual()));
    }

    @Override
    public void isEqualTo(Object expected) {
        long[] actual = (long[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            long[] expectedArray = (long[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Longs.asList((long[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        long[] actual = (long[])this.actual();
        try {
            long[] expectedArray = (long[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Longs.asList((long[])expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public IterableSubject asList() {
        return this.internalCustomName() != null ? (IterableSubject)this.check().that(this.listRepresentation()).named(this.internalCustomName(), new Object[0]) : this.check().that(this.listRepresentation());
    }
}

