/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Ints;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveIntArraySubject
extends AbstractArraySubject<PrimitiveIntArraySubject, int[]> {
    PrimitiveIntArraySubject(FailureStrategy failureStrategy, @Nullable int[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "int";
    }

    @Override
    protected List<Integer> listRepresentation() {
        return Ints.asList((int[])((int[])this.actual()));
    }

    @Override
    public void isEqualTo(Object expected) {
        int[] actual = (int[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            int[] expectedArray = (int[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Ints.asList((int[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        int[] actual = (int[])this.actual();
        try {
            int[] expectedArray = (int[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Ints.asList((int[])expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public IterableSubject asList() {
        return this.internalCustomName() != null ? (IterableSubject)this.check().that(this.listRepresentation()).named(this.internalCustomName(), new Object[0]) : this.check().that(this.listRepresentation());
    }
}

