/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.StringUtil;
import javax.annotation.Nullable;

public class FailureContext {
    private static final String PLACEHOLDER_ERR = "Incorrect number of args (%s) for the given placeholders (%s) in string template:\"%s\"";
    private final String format;
    private final Object[] args;

    public FailureContext(@Nullable String format, Object ... args) {
        this.format = format;
        this.args = args;
        int placeholders = FailureContext.countPlaceholders(format);
        Preconditions.checkArgument((placeholders == args.length ? 1 : 0) != 0, (String)PLACEHOLDER_ERR, (Object)args.length, (Object)placeholders, (Object)format);
    }

    @Nullable
    protected String getFailureMessage() {
        return this.hasFailureMessage() ? StringUtil.format(this.format, this.args) : null;
    }

    protected boolean hasFailureMessage() {
        return this.format != null;
    }

    static int countPlaceholders(@Nullable String template) {
        if (template == null) {
            return 0;
        }
        int index = 0;
        int count = 0;
        while ((index = template.indexOf("%s", index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }
}

