/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringUtil;
import com.google.common.truth.TestVerb;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@GwtIncompatible(value="JUnit4")
public class Expect
extends TestVerb
implements TestRule {
    private final ExpectationGatherer gatherer;
    private boolean inRuleContext = false;

    public static Expect create() {
        return Expect.create(new ExpectationGatherer());
    }

    public static Expect create(ExpectationGatherer gatherer) {
        return new Expect(gatherer);
    }

    public static Expect createAndEnableStackTrace() {
        return new Expect(new ExpectationGatherer(true));
    }

    Expect(ExpectationGatherer gatherer) {
        super(gatherer);
        this.gatherer = (ExpectationGatherer)Preconditions.checkNotNull((Object)gatherer);
    }

    public boolean hasFailures() {
        return !this.gatherer.getMessages().isEmpty();
    }

    @Override
    protected FailureStrategy getFailureStrategy() {
        if (!this.inRuleContext) {
            String message = "assertion made on Expect instance, but it's not enabled as a @Rule.";
            throw new IllegalStateException(message);
        }
        return super.getFailureStrategy();
    }

    public Statement apply(final Statement base, Description description) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)description);
        return new Statement(){

            public void evaluate() throws Throwable {
                Expect.this.inRuleContext = true;
                base.evaluate();
                Expect.this.inRuleContext = false;
                Throwable earliestCause = null;
                if (!Expect.this.gatherer.getMessages().isEmpty()) {
                    AssertionError error = new AssertionError((Object)Expect.this.gatherer.toString());
                    ((Throwable)((Object)error)).initCause(earliestCause);
                    throw error;
                }
            }
        };
    }

    static final class ExpectationFailure {
        private final String message;
        @Nullable
        private final Throwable cause;

        static ExpectationFailure create(String message, @Nullable Throwable cause) {
            return new ExpectationFailure(message, cause);
        }

        private ExpectationFailure(String message, @Nullable Throwable cause) {
            this.message = (String)Preconditions.checkNotNull((Object)message);
            this.cause = cause;
        }

        String message() {
            return this.message;
        }

        @Nullable
        Throwable cause() {
            return this.cause;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof ExpectationFailure) {
                ExpectationFailure that = (ExpectationFailure)other;
                return this.message.equals(that.message) && Objects.equal((Object)this.cause, (Object)that.cause);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.message, this.cause});
        }
    }

    public static class ExpectationGatherer
    extends FailureStrategy {
        private final List<ExpectationFailure> messages = new ArrayList<ExpectationFailure>();
        private final boolean showStackTrace;

        public ExpectationGatherer() {
            this.showStackTrace = false;
        }

        public ExpectationGatherer(boolean showStackTrace) {
            this.showStackTrace = showStackTrace;
        }

        @Override
        public void fail(String message) {
            this.fail((String)Preconditions.checkNotNull((Object)message), new Throwable(message));
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            String errorMessage = StringUtil.messageFor(message, expected, actual);
            this.fail(errorMessage, new Throwable(errorMessage));
        }

        @Override
        public void fail(String message, Throwable cause) {
            this.messages.add(ExpectationFailure.create(message, cause));
        }

        public List<ExpectationFailure> getMessages() {
            return this.messages;
        }

        public String toString() {
            Throwable earliestCause = null;
            StringBuilder message = new StringBuilder("All failed expectations:\n");
            int count = 0;
            for (ExpectationFailure failure : this.getMessages()) {
                if (earliestCause == null && failure.cause() != null) {
                    earliestCause = failure.cause();
                }
                message.append("  ").append(count++ + 1).append(". ").append(failure.message()).append("\n");
                if (!this.showStackTrace || failure.cause() == null) continue;
                StringWriter stackTraceWriter = new StringWriter();
                failure.cause().printStackTrace(new PrintWriter(stackTraceWriter));
                message.append(stackTraceWriter + "\n");
            }
            return message.toString();
        }
    }
}

