/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.AbstractVerb;
import com.google.common.truth.DelegatedVerbFactory;
import com.google.common.truth.FailureContext;
import com.google.common.truth.FailureStrategy;
import javax.annotation.Nullable;

public abstract class AbstractDelegatedVerb<V extends AbstractDelegatedVerb<V>> {
    private final DelegatedVerbFactory<V> factory;
    protected final FailureStrategy failureStrategy;

    protected AbstractDelegatedVerb(FailureStrategy failureStrategy, DelegatedVerbFactory<V> factory) {
        this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
        this.factory = (DelegatedVerbFactory)Preconditions.checkNotNull(factory);
    }

    public final V withFailureMessage(@Nullable String failureMessage) {
        return failureMessage == null ? this.withFailureMessage(null, new Object[0]) : this.withFailureMessage("%s", failureMessage);
    }

    public final V withFailureMessage(@Nullable String format, Object ... args) {
        FailureContext holder = new FailureContext(format, args);
        return this.factory.createVerb(new AbstractVerb.MessagePrependingFailureStrategy(this.failureStrategy, holder));
    }
}

