/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Iterator;
import java.util.Map;

@GwtCompatible
public class MultimapKeySetTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testKeySet() {
        for (Map.Entry entry : this.getSampleElements()) {
            MultimapKeySetTester.assertTrue((boolean)this.multimap().keySet().contains(entry.getKey()));
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testKeySetContainsNullKeyPresent() {
        this.initMultimapWithNullKey();
        MultimapKeySetTester.assertTrue((boolean)this.multimap().keySet().contains(null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testKeySetContainsNullKeyAbsent() {
        MultimapKeySetTester.assertFalse((boolean)this.multimap().keySet().contains(null));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testKeySetRemovePropagatesToMultimap() {
        int key0Count = this.multimap().get(this.k0()).size();
        MultimapKeySetTester.assertEquals((key0Count > 0 ? 1 : 0) != 0, (boolean)this.multimap().keySet().remove(this.k0()));
        MultimapKeySetTester.assertEquals((int)(this.getNumElements() - key0Count), (int)this.multimap().size());
        this.assertGet(this.k0(), new Object[0]);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testKeySetIteratorRemove() {
        int key0Count = this.multimap().get(this.k0()).size();
        Iterator keyItr = this.multimap().keySet().iterator();
        while (keyItr.hasNext()) {
            if (!keyItr.next().equals(this.k0())) continue;
            keyItr.remove();
        }
        MultimapKeySetTester.assertEquals((int)(this.getNumElements() - key0Count), (int)this.multimap().size());
        this.assertGet(this.k0(), new Object[0]);
    }
}

