/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import com.sun.tools.sjavac.Log;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.tools.JavaFileObject;

public class PathAndPackageVerifier
implements TaskListener {
    Set<CompilationUnitTree> misplacedCompilationUnits = new HashSet<CompilationUnitTree>();

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() == TaskEvent.Kind.ANALYZE) {
            CompilationUnitTree cu = e.getCompilationUnit();
            if (cu == null) {
                return;
            }
            JavaFileObject jfo = cu.getSourceFile();
            if (jfo == null) {
                return;
            }
            JCTree pkg = (JCTree)((Object)cu.getPackageName());
            if (pkg == null) {
                return;
            }
            Path dir = Paths.get(jfo.toUri()).normalize().getParent();
            if (!this.checkPathAndPackage(dir, pkg)) {
                this.misplacedCompilationUnits.add(cu);
            }
        }
        if (e.getKind() == TaskEvent.Kind.COMPILATION) {
            for (CompilationUnitTree cu : this.misplacedCompilationUnits) {
                Log.error("Misplaced compilation unit.");
                Log.error("    Directory: " + Paths.get(cu.getSourceFile().toUri()).getParent());
                Log.error("    Package:   " + cu.getPackageName());
            }
        }
    }

    public boolean errorsDiscovered() {
        return this.misplacedCompilationUnits.size() > 0;
    }

    private boolean checkPathAndPackage(Path dir, JCTree pkgName) {
        ParentIterator pathIter = new ParentIterator(dir);
        EnclosingPkgIterator pkgIter = new EnclosingPkgIterator(pkgName);
        while (pathIter.hasNext() && pkgIter.hasNext()) {
            if (((String)pathIter.next()).equals(pkgIter.next())) continue;
            return false;
        }
        return !pkgIter.hasNext();
    }

    private static class EnclosingPkgIterator
    implements Iterator<String> {
        JCTree next;

        EnclosingPkgIterator(JCTree initial) {
            this.next = initial;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            Name name;
            if (this.next instanceof JCTree.JCIdent) {
                name = ((JCTree.JCIdent)this.next).name;
                this.next = null;
            } else {
                JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)this.next;
                name = fa.name;
                this.next = fa.selected;
            }
            return name.toString();
        }
    }

    private static class ParentIterator
    implements Iterator<String> {
        Path next;

        ParentIterator(Path initial) {
            this.next = initial;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String tmp = this.next.getFileName().toString();
            this.next = this.next.getParent();
            return tmp;
        }
    }
}

