/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.javac.main.Main;
import com.sun.tools.sjavac.CompileChunk;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.CompilationService;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import com.sun.tools.sjavac.server.CompilationSubResult;
import com.sun.tools.sjavac.server.SysInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CompileJavaPackages
implements Transformer {
    static final int limitOnConcurrency = 3;
    Options args;

    @Override
    public void setExtra(String e) {
    }

    @Override
    public void setExtra(Options a) {
        this.args = a;
    }

    @Override
    public boolean transform(CompilationService sjavac, Map<String, Set<URI>> pkgSrcs, Set<URI> visibleSources, Map<String, Set<String>> oldPackageDependents, URI destRoot, Map<String, Set<URI>> packageArtifacts, Map<String, Map<String, Set<String>>> packageDependencies, Map<String, Map<String, Set<String>>> packageCpDependencies, Map<String, PubApi> packagePubapis, Map<String, PubApi> dependencyPubapis, int debugLevel, boolean incremental, int numCores) {
        Log.debug("Performing CompileJavaPackages transform...");
        boolean rc = true;
        boolean concurrentCompiles = true;
        String id = String.valueOf(new Random().nextInt());
        SysInfo sysinfo = sjavac.getSysInfo();
        int numMBytes = (int)(sysinfo.maxMemory / 0x100000L);
        Log.debug("Server reports " + numMBytes + "MiB of memory and " + sysinfo.numCores + " cores");
        if (numCores <= 0) {
            numCores = sysinfo.numCores;
            Log.debug("Number of jobs not explicitly set, defaulting to " + sysinfo.numCores);
        } else if (sysinfo.numCores < numCores) {
            Log.debug("Limiting jobs from explicitly set " + numCores + " to cores available on server: " + sysinfo.numCores);
            numCores = sysinfo.numCores;
        } else {
            Log.debug("Number of jobs explicitly set to " + numCores);
        }
        int numCompiles = numCores;
        if (numCores > 3) {
            numCompiles = 3;
        }
        int numSources = 0;
        for (String s : pkgSrcs.keySet()) {
            Set<URI> ss = pkgSrcs.get(s);
            numSources += ss.size();
        }
        int sourcesPerCompile = numSources / numCompiles;
        int kbPerFile = 175;
        String osarch = System.getProperty("os.arch");
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            kbPerFile = 119;
        }
        int numRequiredMBytes = kbPerFile * numSources / 1024;
        Log.debug("For os.arch " + osarch + " the empirically determined heap required per file is " + kbPerFile + "KiB");
        Log.debug("Server has " + numMBytes + "MiB of heap.");
        Log.debug("Heuristics say that we need " + numRequiredMBytes + "MiB of heap for all source files.");
        if (numMBytes < numRequiredMBytes) {
            concurrentCompiles = false;
            if (numSources < 500) {
                numCompiles = 1;
                sourcesPerCompile = numSources;
                Log.debug("Compiling as a single source code chunk to stay within heap size limitations!");
            } else if (sourcesPerCompile > 500) {
                numCompiles = numSources / 500;
                sourcesPerCompile = numSources / numCompiles;
                Log.debug("Compiling source as " + numCompiles + " code chunks serially to stay within heap size limitations!");
            }
        } else if (numCompiles > 1) {
            float usagePerCompile = (float)numRequiredMBytes / ((float)numCompiles * 0.7f);
            int usage = (int)(usagePerCompile * (float)numCompiles);
            Log.debug("Heuristics say that for " + numCompiles + " concurrent compiles we need " + usage + "MiB");
            if (usage > numMBytes) {
                numCompiles = 1;
                sourcesPerCompile = numSources;
                Log.debug("Limiting compile to a single thread to stay within heap size limitations!");
            }
        }
        Log.debug("Compiling sources in " + numCompiles + " chunk(s)");
        CompileChunk[] compileChunks = this.createCompileChunks(pkgSrcs, oldPackageDependents, numCompiles, sourcesPerCompile);
        if (Log.isDebugging()) {
            int cn = 1;
            for (CompileChunk cc : compileChunks) {
                Log.debug("Chunk " + cn + " for " + id + " ---------------");
                ++cn;
                for (URI u : cc.srcs) {
                    Log.debug("" + u);
                }
            }
        }
        long start = System.currentTimeMillis();
        ArrayList<Callable<CompilationSubResult>> compilationCalls = new ArrayList<Callable<CompilationSubResult>>();
        Object lock = new Object();
        for (int i = 0; i < numCompiles; ++i) {
            CompileChunk cc = compileChunks[i];
            if (cc.srcs.isEmpty()) continue;
            String chunkId = id + "-" + String.valueOf(i);
            Iterator log = Log.get();
            compilationCalls.add(() -> {
                Log.setLogForCurrentThread(log);
                CompilationSubResult result = sjavac.compile("n/a", chunkId, this.args.prepJavacArgs(), Collections.emptyList(), cc.srcs, visibleSources);
                Object object = lock;
                synchronized (object) {
                    Util.getLines(result.stdout).forEach(Log::info);
                    Util.getLines(result.stderr).forEach(Log::error);
                }
                return result;
            });
        }
        ArrayList<CompilationSubResult> subResults = new ArrayList<CompilationSubResult>();
        ArrayList futs = new ArrayList();
        ExecutorService exec = Executors.newFixedThreadPool(concurrentCompiles ? compilationCalls.size() : 1);
        for (Callable callable : compilationCalls) {
            futs.add(exec.submit(callable));
        }
        for (Future future : futs) {
            try {
                subResults.add((CompilationSubResult)future.get());
            }
            catch (ExecutionException ee) {
                Log.error("Compilation failed: " + ee.getMessage());
                Log.error(ee);
            }
            catch (InterruptedException ie) {
                Log.error("Compilation interrupted: " + ie.getMessage());
                Log.error(ie);
                Thread.currentThread().interrupt();
            }
        }
        exec.shutdownNow();
        for (CompilationSubResult compilationSubResult : subResults) {
            for (String pkg : compilationSubResult.packageArtifacts.keySet()) {
                Set<URI> pkgArtifacts = compilationSubResult.packageArtifacts.get(pkg);
                packageArtifacts.merge(pkg, pkgArtifacts, Util::union);
            }
            for (String pkg : compilationSubResult.packageDependencies.keySet()) {
                packageDependencies.putIfAbsent(pkg, new HashMap());
                packageDependencies.get(pkg).putAll(compilationSubResult.packageDependencies.get(pkg));
            }
            for (String pkg : compilationSubResult.packageCpDependencies.keySet()) {
                packageCpDependencies.putIfAbsent(pkg, new HashMap());
                packageCpDependencies.get(pkg).putAll(compilationSubResult.packageCpDependencies.get(pkg));
            }
            for (String pkg : compilationSubResult.packagePubapis.keySet()) {
                packagePubapis.merge(pkg, compilationSubResult.packagePubapis.get(pkg), PubApi::mergeTypes);
            }
            for (String pkg : compilationSubResult.dependencyPubapis.keySet()) {
                dependencyPubapis.merge(pkg, compilationSubResult.dependencyPubapis.get(pkg), PubApi::mergeTypes);
            }
            if (compilationSubResult.result == Main.Result.OK) continue;
            rc = false;
        }
        long duration = System.currentTimeMillis() - start;
        long minutes = duration / 60000L;
        long seconds = (duration - minutes * 60000L) / 1000L;
        Log.debug("Compilation of " + numSources + " source files took " + minutes + "m " + seconds + "s");
        return rc;
    }

    CompileChunk[] createCompileChunks(Map<String, Set<URI>> pkgSrcs, Map<String, Set<String>> oldPackageDependents, int numCompiles, int sourcesPerCompile) {
        Object[] compileChunks = new CompileChunk[numCompiles];
        for (int i = 0; i < compileChunks.length; ++i) {
            compileChunks[i] = new CompileChunk();
        }
        int ci = 0;
        Object[] packageNames = pkgSrcs.keySet().toArray(new String[0]);
        Arrays.sort(packageNames);
        String from = null;
        for (Object pkgName : packageNames) {
            Object cc = compileChunks[ci];
            Set<URI> s = pkgSrcs.get(pkgName);
            if (((CompileChunk)cc).srcs.size() + s.size() > sourcesPerCompile && ci < numCompiles - 1) {
                from = null;
                cc = compileChunks[++ci];
            }
            ++((CompileChunk)cc).numPackages;
            ((CompileChunk)cc).srcs.addAll(s);
            String justPkgName = Util.justPackageName((String)pkgName);
            Set<String> ss = oldPackageDependents.get(pkgName);
            if (ss != null) {
                ((CompileChunk)cc).numDependents += ss.size();
            }
            if (from == null || from.trim().equals("")) {
                from = justPkgName;
            }
            ((CompileChunk)cc).pkgNames.append(justPkgName + "(" + s.size() + ") ");
            ((CompileChunk)cc).pkgFromTos = from + " to " + justPkgName;
        }
        Arrays.sort(compileChunks);
        return compileChunks;
    }
}

