/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;

interface SerializationCodeGenerator {
    public void addSerializationCode(Context var1);

    public void addDeserializationCode(Context var1);

    public static interface PrimitiveValueSerializationCodeGenerator
    extends SerializationCodeGenerator {
        public boolean matches(PrimitiveType var1);
    }

    public static interface Marshaller
    extends SerializationCodeGenerator {
        public boolean matches(DeclaredType var1);
    }

    public static class Context {
        public final MethodSpec.Builder builder;
        public final TypeMirror type;
        public final String name;
        public final int depth;

        Context(MethodSpec.Builder builder, TypeMirror type, String name) {
            this(builder, type, name, 0);
        }

        private Context(MethodSpec.Builder builder, TypeMirror type, String name, int depth) {
            this.builder = builder;
            this.type = type;
            this.name = name;
            this.depth = depth;
        }

        Context with(TypeMirror newType, String newName) {
            return new Context(this.builder, newType, newName, this.depth + 1);
        }

        TypeName getTypeName() {
            return TypeName.get((TypeMirror)this.type);
        }

        DeclaredType getDeclaredType() {
            Preconditions.checkState((boolean)(this.type instanceof DeclaredType), (Object)("Expected DeclaredType, was " + this.type));
            return (DeclaredType)this.type;
        }

        boolean isDeclaredType() {
            return this.type instanceof DeclaredType;
        }

        TypeMirror getTypeMirror() {
            return this.type;
        }

        boolean canBeNull() {
            return !(this.type instanceof PrimitiveType);
        }

        String makeName(String name) {
            return name + this.depth;
        }
    }
}

