/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.packaging;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;

public class PackagingUtils {
    public static final ImmutableList<String> NON_RESOURCES_EXTENSIONS = ImmutableList.builder().add((Object)"aidl").add((Object)"rs").add((Object)"fs").add((Object)"rsh").add((Object)"d").add((Object)"java").add((Object)"scala").add((Object)"scc").add((Object)"swp").build();
    public static final ImmutableList<String> NON_RESOURCES_FILENAMES = ImmutableList.builder().add((Object)"thumbs.db").add((Object)"picasa.ini").add((Object)"about.html").add((Object)"package.html").add((Object)"overview.html").build();

    public static boolean checkFolderForPackaging(String folderName) {
        return !folderName.equalsIgnoreCase("CVS") && !folderName.equalsIgnoreCase(".svn") && !folderName.equalsIgnoreCase("SCCS") && !folderName.startsWith("_");
    }

    public static boolean checkFileForPackaging(String fileName, boolean allowClassFiles) {
        String[] fileSegments = fileName.split("\\.");
        String fileExt = "";
        if (fileSegments.length > 1) {
            fileExt = fileSegments[fileSegments.length - 1];
        }
        return PackagingUtils.checkFileForPackaging(fileName, fileExt, allowClassFiles);
    }

    public static boolean checkFileForPackaging(String fileName) {
        return PackagingUtils.checkFileForPackaging(fileName, false);
    }

    public static boolean checkFileForPackaging(String fileName, String extension, boolean allowClassFiles) {
        return fileName.charAt(0) != '.' && fileName.charAt(fileName.length() - 1) != '~' && !PackagingUtils.isOfNonResourcesExtensions(extension, allowClassFiles) && !PackagingUtils.isNotAResourceFile(fileName);
    }

    public static boolean checkFileForPackaging(String fileName, String extension) {
        return fileName.charAt(0) != '.' && fileName.charAt(fileName.length() - 1) != '~' && !PackagingUtils.isOfNonResourcesExtensions(extension, false) && !PackagingUtils.isNotAResourceFile(fileName);
    }

    private static boolean isOfNonResourcesExtensions(String extension, boolean allowClassFiles) {
        for (String ext : NON_RESOURCES_EXTENSIONS) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return !allowClassFiles && "class".equals(extension);
    }

    private static boolean isNotAResourceFile(String fileName) {
        for (String name : NON_RESOURCES_FILENAMES) {
            if (!name.equalsIgnoreCase(fileName)) continue;
            return true;
        }
        return false;
    }

    public static long computeApplicationHash(File projectDir) {
        HashFunction hashFunction = Hashing.md5();
        Hasher hasher = hashFunction.newHasher();
        try {
            projectDir = projectDir.getCanonicalFile();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        String path = projectDir.getPath();
        hasher.putBytes(path.getBytes(Charsets.UTF_8));
        String user = System.getProperty("user.name");
        if (user != null) {
            hasher.putBytes(user.getBytes(Charsets.UTF_8));
        }
        return hasher.hash().asLong();
    }
}

